package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class PipelineResourceRefBuilder extends PipelineResourceRefFluentImpl<PipelineResourceRefBuilder> implements VisitableBuilder<PipelineResourceRef,PipelineResourceRefBuilder>{

    PipelineResourceRefFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PipelineResourceRefBuilder(){
            this(true);
    }
    public PipelineResourceRefBuilder(Boolean validationEnabled){
            this(new PipelineResourceRef(), validationEnabled);
    }
    public PipelineResourceRefBuilder(PipelineResourceRefFluent<?> fluent){
            this(fluent, true);
    }
    public PipelineResourceRefBuilder(PipelineResourceRefFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PipelineResourceRef(), validationEnabled);
    }
    public PipelineResourceRefBuilder(PipelineResourceRefFluent<?> fluent,PipelineResourceRef instance){
            this(fluent, instance, true);
    }
    public PipelineResourceRefBuilder(PipelineResourceRefFluent<?> fluent,PipelineResourceRef instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineResourceRefBuilder(PipelineResourceRef instance){
            this(instance,true);
    }
    public PipelineResourceRefBuilder(PipelineResourceRef instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineResourceRefBuilder(Validator validator){
            this(new PipelineResourceRef(), true);
    }
    public PipelineResourceRefBuilder(PipelineResourceRefFluent<?> fluent,PipelineResourceRef instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withName(instance.getName()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public PipelineResourceRefBuilder(PipelineResourceRef instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withName(instance.getName()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public PipelineResourceRef build(){
            PipelineResourceRef buildable = new PipelineResourceRef(fluent.getApiVersion(),fluent.getName());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PipelineResourceRefBuilder that = (PipelineResourceRefBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
