package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class PipelineResourceResultBuilder extends PipelineResourceResultFluentImpl<PipelineResourceResultBuilder> implements VisitableBuilder<PipelineResourceResult,PipelineResourceResultBuilder>{

    PipelineResourceResultFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PipelineResourceResultBuilder(){
            this(true);
    }
    public PipelineResourceResultBuilder(Boolean validationEnabled){
            this(new PipelineResourceResult(), validationEnabled);
    }
    public PipelineResourceResultBuilder(PipelineResourceResultFluent<?> fluent){
            this(fluent, true);
    }
    public PipelineResourceResultBuilder(PipelineResourceResultFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PipelineResourceResult(), validationEnabled);
    }
    public PipelineResourceResultBuilder(PipelineResourceResultFluent<?> fluent,PipelineResourceResult instance){
            this(fluent, instance, true);
    }
    public PipelineResourceResultBuilder(PipelineResourceResultFluent<?> fluent,PipelineResourceResult instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDigest(instance.getDigest()); 
            fluent.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineResourceResultBuilder(PipelineResourceResult instance){
            this(instance,true);
    }
    public PipelineResourceResultBuilder(PipelineResourceResult instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDigest(instance.getDigest()); 
            this.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineResourceResultBuilder(Validator validator){
            this(new PipelineResourceResult(), true);
    }
    public PipelineResourceResultBuilder(PipelineResourceResultFluent<?> fluent,PipelineResourceResult instance,Validator validator){
            this.fluent = fluent; 
            fluent.withDigest(instance.getDigest()); 
            fluent.withName(instance.getName()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public PipelineResourceResultBuilder(PipelineResourceResult instance,Validator validator){
            this.fluent = this; 
            this.withDigest(instance.getDigest()); 
            this.withName(instance.getName()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public PipelineResourceResult build(){
            PipelineResourceResult buildable = new PipelineResourceResult(fluent.getDigest(),fluent.getName());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PipelineResourceResultBuilder that = (PipelineResourceResultBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
