package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface PipelineResourceSpecFluent<A extends PipelineResourceSpecFluent<A>> extends Fluent<A>{


    public A addToParams(int index,Param item);
    public A setToParams(int index,Param item);
    public A addToParams(Param... items);
    public A addAllToParams(Collection<Param> items);
    public A removeFromParams(Param... items);
    public A removeAllFromParams(Collection<Param> items);
    
/**
 * This method has been deprecated, please use method buildParams instead.
 * @return The buildable object.
 */
@Deprecated public List<Param> getParams();
    public List<Param> buildParams();
    public Param buildParam(int index);
    public Param buildFirstParam();
    public Param buildLastParam();
    public Param buildMatchingParam(io.fabric8.kubernetes.api.builder.Predicate<ParamBuilder> predicate);
    public Boolean hasMatchingParam(io.fabric8.kubernetes.api.builder.Predicate<ParamBuilder> predicate);
    public A withParams(List<Param> params);
    public A withParams(Param... params);
    public Boolean hasParams();
    public A addNewParam(String name,String value);
    public PipelineResourceSpecFluent.ParamsNested<A> addNewParam();
    public PipelineResourceSpecFluent.ParamsNested<A> addNewParamLike(Param item);
    public PipelineResourceSpecFluent.ParamsNested<A> setNewParamLike(int index,Param item);
    public PipelineResourceSpecFluent.ParamsNested<A> editParam(int index);
    public PipelineResourceSpecFluent.ParamsNested<A> editFirstParam();
    public PipelineResourceSpecFluent.ParamsNested<A> editLastParam();
    public PipelineResourceSpecFluent.ParamsNested<A> editMatchingParam(io.fabric8.kubernetes.api.builder.Predicate<ParamBuilder> predicate);
    public A addToSecrets(int index,SecretParam item);
    public A setToSecrets(int index,SecretParam item);
    public A addToSecrets(SecretParam... items);
    public A addAllToSecrets(Collection<SecretParam> items);
    public A removeFromSecrets(SecretParam... items);
    public A removeAllFromSecrets(Collection<SecretParam> items);
    
/**
 * This method has been deprecated, please use method buildSecrets instead.
 * @return The buildable object.
 */
@Deprecated public List<SecretParam> getSecrets();
    public List<SecretParam> buildSecrets();
    public SecretParam buildSecret(int index);
    public SecretParam buildFirstSecret();
    public SecretParam buildLastSecret();
    public SecretParam buildMatchingSecret(io.fabric8.kubernetes.api.builder.Predicate<SecretParamBuilder> predicate);
    public Boolean hasMatchingSecret(io.fabric8.kubernetes.api.builder.Predicate<SecretParamBuilder> predicate);
    public A withSecrets(List<SecretParam> secrets);
    public A withSecrets(SecretParam... secrets);
    public Boolean hasSecrets();
    public A addNewSecret(String fieldName,String secretKey,String secretName);
    public PipelineResourceSpecFluent.SecretsNested<A> addNewSecret();
    public PipelineResourceSpecFluent.SecretsNested<A> addNewSecretLike(SecretParam item);
    public PipelineResourceSpecFluent.SecretsNested<A> setNewSecretLike(int index,SecretParam item);
    public PipelineResourceSpecFluent.SecretsNested<A> editSecret(int index);
    public PipelineResourceSpecFluent.SecretsNested<A> editFirstSecret();
    public PipelineResourceSpecFluent.SecretsNested<A> editLastSecret();
    public PipelineResourceSpecFluent.SecretsNested<A> editMatchingSecret(io.fabric8.kubernetes.api.builder.Predicate<SecretParamBuilder> predicate);
    public String getType();
    public A withType(String type);
    public Boolean hasType();
    public A withNewType(String arg1);
    public A withNewType(StringBuilder arg1);
    public A withNewType(StringBuffer arg1);

    public interface ParamsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ParamFluent<PipelineResourceSpecFluent.ParamsNested<N>>{

        
    public N and();    public N endParam();
}
    public interface SecretsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SecretParamFluent<PipelineResourceSpecFluent.SecretsNested<N>>{

        
    public N and();    public N endSecret();
}


}
