package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;

public interface PipelineRunFluent<A extends PipelineRunFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public PipelineRunFluent.MetadataNested<A> withNewMetadata();
    public PipelineRunFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public PipelineRunFluent.MetadataNested<A> editMetadata();
    public PipelineRunFluent.MetadataNested<A> editOrNewMetadata();
    public PipelineRunFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public PipelineRunSpec getSpec();
    public PipelineRunSpec buildSpec();
    public A withSpec(PipelineRunSpec spec);
    public Boolean hasSpec();
    public PipelineRunFluent.SpecNested<A> withNewSpec();
    public PipelineRunFluent.SpecNested<A> withNewSpecLike(PipelineRunSpec item);
    public PipelineRunFluent.SpecNested<A> editSpec();
    public PipelineRunFluent.SpecNested<A> editOrNewSpec();
    public PipelineRunFluent.SpecNested<A> editOrNewSpecLike(PipelineRunSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public PipelineRunStatus getStatus();
    public PipelineRunStatus buildStatus();
    public A withStatus(PipelineRunStatus status);
    public Boolean hasStatus();
    public PipelineRunFluent.StatusNested<A> withNewStatus();
    public PipelineRunFluent.StatusNested<A> withNewStatusLike(PipelineRunStatus item);
    public PipelineRunFluent.StatusNested<A> editStatus();
    public PipelineRunFluent.StatusNested<A> editOrNewStatus();
    public PipelineRunFluent.StatusNested<A> editOrNewStatusLike(PipelineRunStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<PipelineRunFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PipelineRunSpecFluent<PipelineRunFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PipelineRunStatusFluent<PipelineRunFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
