package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class PipelineRunListBuilder extends PipelineRunListFluentImpl<PipelineRunListBuilder> implements VisitableBuilder<PipelineRunList,PipelineRunListBuilder>{

    PipelineRunListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PipelineRunListBuilder(){
            this(true);
    }
    public PipelineRunListBuilder(Boolean validationEnabled){
            this(new PipelineRunList(), validationEnabled);
    }
    public PipelineRunListBuilder(PipelineRunListFluent<?> fluent){
            this(fluent, true);
    }
    public PipelineRunListBuilder(PipelineRunListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PipelineRunList(), validationEnabled);
    }
    public PipelineRunListBuilder(PipelineRunListFluent<?> fluent,PipelineRunList instance){
            this(fluent, instance, true);
    }
    public PipelineRunListBuilder(PipelineRunListFluent<?> fluent,PipelineRunList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineRunListBuilder(PipelineRunList instance){
            this(instance,true);
    }
    public PipelineRunListBuilder(PipelineRunList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineRunListBuilder(Validator validator){
            this(new PipelineRunList(), true);
    }
    public PipelineRunListBuilder(PipelineRunListFluent<?> fluent,PipelineRunList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public PipelineRunListBuilder(PipelineRunList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public PipelineRunList build(){
            PipelineRunList buildable = new PipelineRunList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PipelineRunListBuilder that = (PipelineRunListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
