package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface PipelineRunListFluent<A extends PipelineRunListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,PipelineRun item);
    public A setToItems(int index,PipelineRun item);
    public A addToItems(PipelineRun... items);
    public A addAllToItems(Collection<PipelineRun> items);
    public A removeFromItems(PipelineRun... items);
    public A removeAllFromItems(Collection<PipelineRun> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<PipelineRun> getItems();
    public List<PipelineRun> buildItems();
    public PipelineRun buildItem(int index);
    public PipelineRun buildFirstItem();
    public PipelineRun buildLastItem();
    public PipelineRun buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<PipelineRunBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<PipelineRunBuilder> predicate);
    public A withItems(List<PipelineRun> items);
    public A withItems(PipelineRun... items);
    public Boolean hasItems();
    public PipelineRunListFluent.ItemsNested<A> addNewItem();
    public PipelineRunListFluent.ItemsNested<A> addNewItemLike(PipelineRun item);
    public PipelineRunListFluent.ItemsNested<A> setNewItemLike(int index,PipelineRun item);
    public PipelineRunListFluent.ItemsNested<A> editItem(int index);
    public PipelineRunListFluent.ItemsNested<A> editFirstItem();
    public PipelineRunListFluent.ItemsNested<A> editLastItem();
    public PipelineRunListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<PipelineRunBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PipelineRunFluent<PipelineRunListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
