package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class PipelineRunSpecFluentImpl<A extends PipelineRunSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PipelineRunSpecFluent<A>{

    private Affinity affinity;
    private Map<String,String> nodeSelector;
    private List<ParamBuilder> params;
    private PipelineRefBuilder pipelineRef;
    private List<PipelineResourceBindingBuilder> resources;
    private ResultsBuilder results;
    private String serviceAccount;
    private List<PipelineRunSpecServiceAccountBuilder> serviceAccounts;
    private String status;
    private String timeout;
    private List<Toleration> tolerations;

    public PipelineRunSpecFluentImpl(){
    }
    public PipelineRunSpecFluentImpl(PipelineRunSpec instance){
            this.withAffinity(instance.getAffinity()); 
            this.withNodeSelector(instance.getNodeSelector()); 
            this.withParams(instance.getParams()); 
            this.withPipelineRef(instance.getPipelineRef()); 
            this.withResources(instance.getResources()); 
            this.withResults(instance.getResults()); 
            this.withServiceAccount(instance.getServiceAccount()); 
            this.withServiceAccounts(instance.getServiceAccounts()); 
            this.withStatus(instance.getStatus()); 
            this.withTimeout(instance.getTimeout()); 
            this.withTolerations(instance.getTolerations()); 
    }

    public Affinity getAffinity(){
            return this.affinity;
    }

    public A withAffinity(Affinity affinity){
            this.affinity=affinity; return (A) this;
    }

    public Boolean hasAffinity(){
            return this.affinity != null;
    }

    public A addToNodeSelector(String key,String value){
            if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
    }

    public A addToNodeSelector(Map<String,String> map){
            if(this.nodeSelector == null && map != null) { this.nodeSelector = new LinkedHashMap<String,String>(); }
            if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
    }

    public A removeFromNodeSelector(String key){
            if(this.nodeSelector == null) { return (A) this; }
            if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
    }

    public A removeFromNodeSelector(Map<String,String> map){
            if(this.nodeSelector == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
    }

    public Map<String,String> getNodeSelector(){
            return this.nodeSelector;
    }

    public A withNodeSelector(Map<String,String> nodeSelector){
            if (nodeSelector == null) { this.nodeSelector =  new LinkedHashMap<String,String>();} else {this.nodeSelector = new LinkedHashMap<String,String>(nodeSelector);} return (A) this;
    }

    public Boolean hasNodeSelector(){
            return this.nodeSelector != null;
    }

    public A addToParams(int index,Param item){
            if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
            ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").add(index >= 0 ? index : _visitables.get("params").size(), builder);this.params.add(index >= 0 ? index : params.size(), builder); return (A)this;
    }

    public A setToParams(int index,Param item){
            if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
            ParamBuilder builder = new ParamBuilder(item);
            if (index < 0 || index >= _visitables.get("params").size()) { _visitables.get("params").add(builder); } else { _visitables.get("params").set(index, builder);}
            if (index < 0 || index >= params.size()) { params.add(builder); } else { params.set(index, builder);}
             return (A)this;
    }

    public A addToParams(Param... items){
            if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
            for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
    }

    public A addAllToParams(Collection<Param> items){
            if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
            for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
    }

    public A removeFromParams(Param... items){
            for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").remove(builder);if (this.params != null) {this.params.remove(builder);}} return (A)this;
    }

    public A removeAllFromParams(Collection<Param> items){
            for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").remove(builder);if (this.params != null) {this.params.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildParams instead.
 * @return The buildable object.
 */
@Deprecated public List<Param> getParams(){
            return build(params);
    }

    public List<Param> buildParams(){
            return build(params);
    }

    public Param buildParam(int index){
            return this.params.get(index).build();
    }

    public Param buildFirstParam(){
            return this.params.get(0).build();
    }

    public Param buildLastParam(){
            return this.params.get(params.size() - 1).build();
    }

    public Param buildMatchingParam(io.fabric8.kubernetes.api.builder.Predicate<ParamBuilder> predicate){
            for (ParamBuilder item: params) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingParam(io.fabric8.kubernetes.api.builder.Predicate<ParamBuilder> predicate){
            for (ParamBuilder item: params) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withParams(List<Param> params){
            if (this.params != null) { _visitables.get("params").removeAll(this.params);}
            if (params != null) {this.params = new ArrayList<ParamBuilder>(); for (Param item : params){this.addToParams(item);}} else { this.params = new ArrayList<ParamBuilder>();} return (A) this;
    }

    public A withParams(Param... params){
            if (this.params != null) {this.params.clear();}
            if (params != null) {for (Param item :params){ this.addToParams(item);}} return (A) this;
    }

    public Boolean hasParams(){
            return params != null && !params.isEmpty();
    }

    public A addNewParam(String name,String value){
            return (A)addToParams(new Param(name, value));
    }

    public PipelineRunSpecFluent.ParamsNested<A> addNewParam(){
            return new ParamsNestedImpl();
    }

    public PipelineRunSpecFluent.ParamsNested<A> addNewParamLike(Param item){
            return new ParamsNestedImpl(-1, item);
    }

    public PipelineRunSpecFluent.ParamsNested<A> setNewParamLike(int index,Param item){
            return new ParamsNestedImpl(index, item);
    }

    public PipelineRunSpecFluent.ParamsNested<A> editParam(int index){
            if (params.size() <= index) throw new RuntimeException("Can't edit params. Index exceeds size.");
            return setNewParamLike(index, buildParam(index));
    }

    public PipelineRunSpecFluent.ParamsNested<A> editFirstParam(){
            if (params.size() == 0) throw new RuntimeException("Can't edit first params. The list is empty.");
            return setNewParamLike(0, buildParam(0));
    }

    public PipelineRunSpecFluent.ParamsNested<A> editLastParam(){
            int index = params.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last params. The list is empty.");
            return setNewParamLike(index, buildParam(index));
    }

    public PipelineRunSpecFluent.ParamsNested<A> editMatchingParam(io.fabric8.kubernetes.api.builder.Predicate<ParamBuilder> predicate){
            int index = -1;
            for (int i=0;i<params.size();i++) { 
            if (predicate.apply(params.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching params. No match found.");
            return setNewParamLike(index, buildParam(index));
    }

    
/**
 * This method has been deprecated, please use method buildPipelineRef instead.
 * @return The buildable object.
 */
@Deprecated public PipelineRef getPipelineRef(){
            return this.pipelineRef!=null?this.pipelineRef.build():null;
    }

    public PipelineRef buildPipelineRef(){
            return this.pipelineRef!=null?this.pipelineRef.build():null;
    }

    public A withPipelineRef(PipelineRef pipelineRef){
            _visitables.get("pipelineRef").remove(this.pipelineRef);
            if (pipelineRef!=null){ this.pipelineRef= new PipelineRefBuilder(pipelineRef); _visitables.get("pipelineRef").add(this.pipelineRef);} return (A) this;
    }

    public Boolean hasPipelineRef(){
            return this.pipelineRef != null;
    }

    public A withNewPipelineRef(String apiVersion,String name){
            return (A)withPipelineRef(new PipelineRef(apiVersion, name));
    }

    public PipelineRunSpecFluent.PipelineRefNested<A> withNewPipelineRef(){
            return new PipelineRefNestedImpl();
    }

    public PipelineRunSpecFluent.PipelineRefNested<A> withNewPipelineRefLike(PipelineRef item){
            return new PipelineRefNestedImpl(item);
    }

    public PipelineRunSpecFluent.PipelineRefNested<A> editPipelineRef(){
            return withNewPipelineRefLike(getPipelineRef());
    }

    public PipelineRunSpecFluent.PipelineRefNested<A> editOrNewPipelineRef(){
            return withNewPipelineRefLike(getPipelineRef() != null ? getPipelineRef(): new PipelineRefBuilder().build());
    }

    public PipelineRunSpecFluent.PipelineRefNested<A> editOrNewPipelineRefLike(PipelineRef item){
            return withNewPipelineRefLike(getPipelineRef() != null ? getPipelineRef(): item);
    }

    public A addToResources(int index,PipelineResourceBinding item){
            if (this.resources == null) {this.resources = new ArrayList<PipelineResourceBindingBuilder>();}
            PipelineResourceBindingBuilder builder = new PipelineResourceBindingBuilder(item);_visitables.get("resources").add(index >= 0 ? index : _visitables.get("resources").size(), builder);this.resources.add(index >= 0 ? index : resources.size(), builder); return (A)this;
    }

    public A setToResources(int index,PipelineResourceBinding item){
            if (this.resources == null) {this.resources = new ArrayList<PipelineResourceBindingBuilder>();}
            PipelineResourceBindingBuilder builder = new PipelineResourceBindingBuilder(item);
            if (index < 0 || index >= _visitables.get("resources").size()) { _visitables.get("resources").add(builder); } else { _visitables.get("resources").set(index, builder);}
            if (index < 0 || index >= resources.size()) { resources.add(builder); } else { resources.set(index, builder);}
             return (A)this;
    }

    public A addToResources(PipelineResourceBinding... items){
            if (this.resources == null) {this.resources = new ArrayList<PipelineResourceBindingBuilder>();}
            for (PipelineResourceBinding item : items) {PipelineResourceBindingBuilder builder = new PipelineResourceBindingBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
    }

    public A addAllToResources(Collection<PipelineResourceBinding> items){
            if (this.resources == null) {this.resources = new ArrayList<PipelineResourceBindingBuilder>();}
            for (PipelineResourceBinding item : items) {PipelineResourceBindingBuilder builder = new PipelineResourceBindingBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
    }

    public A removeFromResources(PipelineResourceBinding... items){
            for (PipelineResourceBinding item : items) {PipelineResourceBindingBuilder builder = new PipelineResourceBindingBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
    }

    public A removeAllFromResources(Collection<PipelineResourceBinding> items){
            for (PipelineResourceBinding item : items) {PipelineResourceBindingBuilder builder = new PipelineResourceBindingBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public List<PipelineResourceBinding> getResources(){
            return build(resources);
    }

    public List<PipelineResourceBinding> buildResources(){
            return build(resources);
    }

    public PipelineResourceBinding buildResource(int index){
            return this.resources.get(index).build();
    }

    public PipelineResourceBinding buildFirstResource(){
            return this.resources.get(0).build();
    }

    public PipelineResourceBinding buildLastResource(){
            return this.resources.get(resources.size() - 1).build();
    }

    public PipelineResourceBinding buildMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<PipelineResourceBindingBuilder> predicate){
            for (PipelineResourceBindingBuilder item: resources) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<PipelineResourceBindingBuilder> predicate){
            for (PipelineResourceBindingBuilder item: resources) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withResources(List<PipelineResourceBinding> resources){
            if (this.resources != null) { _visitables.get("resources").removeAll(this.resources);}
            if (resources != null) {this.resources = new ArrayList<PipelineResourceBindingBuilder>(); for (PipelineResourceBinding item : resources){this.addToResources(item);}} else { this.resources = new ArrayList<PipelineResourceBindingBuilder>();} return (A) this;
    }

    public A withResources(PipelineResourceBinding... resources){
            if (this.resources != null) {this.resources.clear();}
            if (resources != null) {for (PipelineResourceBinding item :resources){ this.addToResources(item);}} return (A) this;
    }

    public Boolean hasResources(){
            return resources != null && !resources.isEmpty();
    }

    public PipelineRunSpecFluent.ResourcesNested<A> addNewResource(){
            return new ResourcesNestedImpl();
    }

    public PipelineRunSpecFluent.ResourcesNested<A> addNewResourceLike(PipelineResourceBinding item){
            return new ResourcesNestedImpl(-1, item);
    }

    public PipelineRunSpecFluent.ResourcesNested<A> setNewResourceLike(int index,PipelineResourceBinding item){
            return new ResourcesNestedImpl(index, item);
    }

    public PipelineRunSpecFluent.ResourcesNested<A> editResource(int index){
            if (resources.size() <= index) throw new RuntimeException("Can't edit resources. Index exceeds size.");
            return setNewResourceLike(index, buildResource(index));
    }

    public PipelineRunSpecFluent.ResourcesNested<A> editFirstResource(){
            if (resources.size() == 0) throw new RuntimeException("Can't edit first resources. The list is empty.");
            return setNewResourceLike(0, buildResource(0));
    }

    public PipelineRunSpecFluent.ResourcesNested<A> editLastResource(){
            int index = resources.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last resources. The list is empty.");
            return setNewResourceLike(index, buildResource(index));
    }

    public PipelineRunSpecFluent.ResourcesNested<A> editMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<PipelineResourceBindingBuilder> predicate){
            int index = -1;
            for (int i=0;i<resources.size();i++) { 
            if (predicate.apply(resources.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching resources. No match found.");
            return setNewResourceLike(index, buildResource(index));
    }

    
/**
 * This method has been deprecated, please use method buildResults instead.
 * @return The buildable object.
 */
@Deprecated public Results getResults(){
            return this.results!=null?this.results.build():null;
    }

    public Results buildResults(){
            return this.results!=null?this.results.build():null;
    }

    public A withResults(Results results){
            _visitables.get("results").remove(this.results);
            if (results!=null){ this.results= new ResultsBuilder(results); _visitables.get("results").add(this.results);} return (A) this;
    }

    public Boolean hasResults(){
            return this.results != null;
    }

    public A withNewResults(String type,String url){
            return (A)withResults(new Results(type, url));
    }

    public PipelineRunSpecFluent.ResultsNested<A> withNewResults(){
            return new ResultsNestedImpl();
    }

    public PipelineRunSpecFluent.ResultsNested<A> withNewResultsLike(Results item){
            return new ResultsNestedImpl(item);
    }

    public PipelineRunSpecFluent.ResultsNested<A> editResults(){
            return withNewResultsLike(getResults());
    }

    public PipelineRunSpecFluent.ResultsNested<A> editOrNewResults(){
            return withNewResultsLike(getResults() != null ? getResults(): new ResultsBuilder().build());
    }

    public PipelineRunSpecFluent.ResultsNested<A> editOrNewResultsLike(Results item){
            return withNewResultsLike(getResults() != null ? getResults(): item);
    }

    public String getServiceAccount(){
            return this.serviceAccount;
    }

    public A withServiceAccount(String serviceAccount){
            this.serviceAccount=serviceAccount; return (A) this;
    }

    public Boolean hasServiceAccount(){
            return this.serviceAccount != null;
    }

    public A withNewServiceAccount(String arg1){
            return (A)withServiceAccount(new String(arg1));
    }

    public A withNewServiceAccount(StringBuilder arg1){
            return (A)withServiceAccount(new String(arg1));
    }

    public A withNewServiceAccount(StringBuffer arg1){
            return (A)withServiceAccount(new String(arg1));
    }

    public A addToServiceAccounts(int index,PipelineRunSpecServiceAccount item){
            if (this.serviceAccounts == null) {this.serviceAccounts = new ArrayList<PipelineRunSpecServiceAccountBuilder>();}
            PipelineRunSpecServiceAccountBuilder builder = new PipelineRunSpecServiceAccountBuilder(item);_visitables.get("serviceAccounts").add(index >= 0 ? index : _visitables.get("serviceAccounts").size(), builder);this.serviceAccounts.add(index >= 0 ? index : serviceAccounts.size(), builder); return (A)this;
    }

    public A setToServiceAccounts(int index,PipelineRunSpecServiceAccount item){
            if (this.serviceAccounts == null) {this.serviceAccounts = new ArrayList<PipelineRunSpecServiceAccountBuilder>();}
            PipelineRunSpecServiceAccountBuilder builder = new PipelineRunSpecServiceAccountBuilder(item);
            if (index < 0 || index >= _visitables.get("serviceAccounts").size()) { _visitables.get("serviceAccounts").add(builder); } else { _visitables.get("serviceAccounts").set(index, builder);}
            if (index < 0 || index >= serviceAccounts.size()) { serviceAccounts.add(builder); } else { serviceAccounts.set(index, builder);}
             return (A)this;
    }

    public A addToServiceAccounts(PipelineRunSpecServiceAccount... items){
            if (this.serviceAccounts == null) {this.serviceAccounts = new ArrayList<PipelineRunSpecServiceAccountBuilder>();}
            for (PipelineRunSpecServiceAccount item : items) {PipelineRunSpecServiceAccountBuilder builder = new PipelineRunSpecServiceAccountBuilder(item);_visitables.get("serviceAccounts").add(builder);this.serviceAccounts.add(builder);} return (A)this;
    }

    public A addAllToServiceAccounts(Collection<PipelineRunSpecServiceAccount> items){
            if (this.serviceAccounts == null) {this.serviceAccounts = new ArrayList<PipelineRunSpecServiceAccountBuilder>();}
            for (PipelineRunSpecServiceAccount item : items) {PipelineRunSpecServiceAccountBuilder builder = new PipelineRunSpecServiceAccountBuilder(item);_visitables.get("serviceAccounts").add(builder);this.serviceAccounts.add(builder);} return (A)this;
    }

    public A removeFromServiceAccounts(PipelineRunSpecServiceAccount... items){
            for (PipelineRunSpecServiceAccount item : items) {PipelineRunSpecServiceAccountBuilder builder = new PipelineRunSpecServiceAccountBuilder(item);_visitables.get("serviceAccounts").remove(builder);if (this.serviceAccounts != null) {this.serviceAccounts.remove(builder);}} return (A)this;
    }

    public A removeAllFromServiceAccounts(Collection<PipelineRunSpecServiceAccount> items){
            for (PipelineRunSpecServiceAccount item : items) {PipelineRunSpecServiceAccountBuilder builder = new PipelineRunSpecServiceAccountBuilder(item);_visitables.get("serviceAccounts").remove(builder);if (this.serviceAccounts != null) {this.serviceAccounts.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildServiceAccounts instead.
 * @return The buildable object.
 */
@Deprecated public List<PipelineRunSpecServiceAccount> getServiceAccounts(){
            return build(serviceAccounts);
    }

    public List<PipelineRunSpecServiceAccount> buildServiceAccounts(){
            return build(serviceAccounts);
    }

    public PipelineRunSpecServiceAccount buildServiceAccount(int index){
            return this.serviceAccounts.get(index).build();
    }

    public PipelineRunSpecServiceAccount buildFirstServiceAccount(){
            return this.serviceAccounts.get(0).build();
    }

    public PipelineRunSpecServiceAccount buildLastServiceAccount(){
            return this.serviceAccounts.get(serviceAccounts.size() - 1).build();
    }

    public PipelineRunSpecServiceAccount buildMatchingServiceAccount(io.fabric8.kubernetes.api.builder.Predicate<PipelineRunSpecServiceAccountBuilder> predicate){
            for (PipelineRunSpecServiceAccountBuilder item: serviceAccounts) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingServiceAccount(io.fabric8.kubernetes.api.builder.Predicate<PipelineRunSpecServiceAccountBuilder> predicate){
            for (PipelineRunSpecServiceAccountBuilder item: serviceAccounts) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withServiceAccounts(List<PipelineRunSpecServiceAccount> serviceAccounts){
            if (this.serviceAccounts != null) { _visitables.get("serviceAccounts").removeAll(this.serviceAccounts);}
            if (serviceAccounts != null) {this.serviceAccounts = new ArrayList<PipelineRunSpecServiceAccountBuilder>(); for (PipelineRunSpecServiceAccount item : serviceAccounts){this.addToServiceAccounts(item);}} else { this.serviceAccounts = new ArrayList<PipelineRunSpecServiceAccountBuilder>();} return (A) this;
    }

    public A withServiceAccounts(PipelineRunSpecServiceAccount... serviceAccounts){
            if (this.serviceAccounts != null) {this.serviceAccounts.clear();}
            if (serviceAccounts != null) {for (PipelineRunSpecServiceAccount item :serviceAccounts){ this.addToServiceAccounts(item);}} return (A) this;
    }

    public Boolean hasServiceAccounts(){
            return serviceAccounts != null && !serviceAccounts.isEmpty();
    }

    public A addNewServiceAccount(String serviceAccount,String taskName){
            return (A)addToServiceAccounts(new PipelineRunSpecServiceAccount(serviceAccount, taskName));
    }

    public PipelineRunSpecFluent.ServiceAccountsNested<A> addNewServiceAccount(){
            return new ServiceAccountsNestedImpl();
    }

    public PipelineRunSpecFluent.ServiceAccountsNested<A> addNewServiceAccountLike(PipelineRunSpecServiceAccount item){
            return new ServiceAccountsNestedImpl(-1, item);
    }

    public PipelineRunSpecFluent.ServiceAccountsNested<A> setNewServiceAccountLike(int index,PipelineRunSpecServiceAccount item){
            return new ServiceAccountsNestedImpl(index, item);
    }

    public PipelineRunSpecFluent.ServiceAccountsNested<A> editServiceAccount(int index){
            if (serviceAccounts.size() <= index) throw new RuntimeException("Can't edit serviceAccounts. Index exceeds size.");
            return setNewServiceAccountLike(index, buildServiceAccount(index));
    }

    public PipelineRunSpecFluent.ServiceAccountsNested<A> editFirstServiceAccount(){
            if (serviceAccounts.size() == 0) throw new RuntimeException("Can't edit first serviceAccounts. The list is empty.");
            return setNewServiceAccountLike(0, buildServiceAccount(0));
    }

    public PipelineRunSpecFluent.ServiceAccountsNested<A> editLastServiceAccount(){
            int index = serviceAccounts.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last serviceAccounts. The list is empty.");
            return setNewServiceAccountLike(index, buildServiceAccount(index));
    }

    public PipelineRunSpecFluent.ServiceAccountsNested<A> editMatchingServiceAccount(io.fabric8.kubernetes.api.builder.Predicate<PipelineRunSpecServiceAccountBuilder> predicate){
            int index = -1;
            for (int i=0;i<serviceAccounts.size();i++) { 
            if (predicate.apply(serviceAccounts.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching serviceAccounts. No match found.");
            return setNewServiceAccountLike(index, buildServiceAccount(index));
    }

    public String getStatus(){
            return this.status;
    }

    public A withStatus(String status){
            this.status=status; return (A) this;
    }

    public Boolean hasStatus(){
            return this.status != null;
    }

    public A withNewStatus(String arg1){
            return (A)withStatus(new String(arg1));
    }

    public A withNewStatus(StringBuilder arg1){
            return (A)withStatus(new String(arg1));
    }

    public A withNewStatus(StringBuffer arg1){
            return (A)withStatus(new String(arg1));
    }

    public String getTimeout(){
            return this.timeout;
    }

    public A withTimeout(String timeout){
            this.timeout=timeout; return (A) this;
    }

    public Boolean hasTimeout(){
            return this.timeout != null;
    }

    public A withNewTimeout(String arg1){
            return (A)withTimeout(new String(arg1));
    }

    public A withNewTimeout(StringBuilder arg1){
            return (A)withTimeout(new String(arg1));
    }

    public A withNewTimeout(StringBuffer arg1){
            return (A)withTimeout(new String(arg1));
    }

    public A addToTolerations(int index,Toleration item){
            if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
            this.tolerations.add(index, item);
            return (A)this;
    }

    public A setToTolerations(int index,Toleration item){
            if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
            this.tolerations.set(index, item); return (A)this;
    }

    public A addToTolerations(Toleration... items){
            if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
            for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
    }

    public A addAllToTolerations(Collection<Toleration> items){
            if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
            for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
    }

    public A removeFromTolerations(Toleration... items){
            for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
    }

    public A removeAllFromTolerations(Collection<Toleration> items){
            for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
    }

    public List<Toleration> getTolerations(){
            return this.tolerations;
    }

    public Toleration getToleration(int index){
            return this.tolerations.get(index);
    }

    public Toleration getFirstToleration(){
            return this.tolerations.get(0);
    }

    public Toleration getLastToleration(){
            return this.tolerations.get(tolerations.size() - 1);
    }

    public Toleration getMatchingToleration(io.fabric8.kubernetes.api.builder.Predicate<Toleration> predicate){
            for (Toleration item: tolerations) { if(predicate.apply(item)){return item;} } return null;
    }

    public Boolean hasMatchingToleration(io.fabric8.kubernetes.api.builder.Predicate<Toleration> predicate){
            for (Toleration item: tolerations) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withTolerations(List<Toleration> tolerations){
            if (this.tolerations != null) { _visitables.get("tolerations").removeAll(this.tolerations);}
            if (tolerations != null) {this.tolerations = new ArrayList<Toleration>(); for (Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = new ArrayList<Toleration>();} return (A) this;
    }

    public A withTolerations(Toleration... tolerations){
            if (this.tolerations != null) {this.tolerations.clear();}
            if (tolerations != null) {for (Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
    }

    public Boolean hasTolerations(){
            return tolerations != null && !tolerations.isEmpty();
    }

    public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value){
            return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PipelineRunSpecFluentImpl that = (PipelineRunSpecFluentImpl) o;
            if (affinity != null ? !affinity.equals(that.affinity) :that.affinity != null) return false;
            if (nodeSelector != null ? !nodeSelector.equals(that.nodeSelector) :that.nodeSelector != null) return false;
            if (params != null ? !params.equals(that.params) :that.params != null) return false;
            if (pipelineRef != null ? !pipelineRef.equals(that.pipelineRef) :that.pipelineRef != null) return false;
            if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
            if (results != null ? !results.equals(that.results) :that.results != null) return false;
            if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
            if (serviceAccounts != null ? !serviceAccounts.equals(that.serviceAccounts) :that.serviceAccounts != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            if (timeout != null ? !timeout.equals(that.timeout) :that.timeout != null) return false;
            if (tolerations != null ? !tolerations.equals(that.tolerations) :that.tolerations != null) return false;
            return true;
    }


    public class ParamsNestedImpl<N> extends ParamFluentImpl<PipelineRunSpecFluent.ParamsNested<N>> implements PipelineRunSpecFluent.ParamsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ParamBuilder builder;
        private final int index;
    
            ParamsNestedImpl(int index,Param item){
                    this.index = index;
                    this.builder = new ParamBuilder(this, item);
            }
            ParamsNestedImpl(){
                    this.index = -1;
                    this.builder = new ParamBuilder(this);
            }
    
    public N and(){
            return (N) PipelineRunSpecFluentImpl.this.setToParams(index, builder.build());
    }
    public N endParam(){
            return and();
    }

}
    public class PipelineRefNestedImpl<N> extends PipelineRefFluentImpl<PipelineRunSpecFluent.PipelineRefNested<N>> implements PipelineRunSpecFluent.PipelineRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PipelineRefBuilder builder;
    
            PipelineRefNestedImpl(PipelineRef item){
                    this.builder = new PipelineRefBuilder(this, item);
            }
            PipelineRefNestedImpl(){
                    this.builder = new PipelineRefBuilder(this);
            }
    
    public N and(){
            return (N) PipelineRunSpecFluentImpl.this.withPipelineRef(builder.build());
    }
    public N endPipelineRef(){
            return and();
    }

}
    public class ResourcesNestedImpl<N> extends PipelineResourceBindingFluentImpl<PipelineRunSpecFluent.ResourcesNested<N>> implements PipelineRunSpecFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PipelineResourceBindingBuilder builder;
        private final int index;
    
            ResourcesNestedImpl(int index,PipelineResourceBinding item){
                    this.index = index;
                    this.builder = new PipelineResourceBindingBuilder(this, item);
            }
            ResourcesNestedImpl(){
                    this.index = -1;
                    this.builder = new PipelineResourceBindingBuilder(this);
            }
    
    public N and(){
            return (N) PipelineRunSpecFluentImpl.this.setToResources(index, builder.build());
    }
    public N endResource(){
            return and();
    }

}
    public class ResultsNestedImpl<N> extends ResultsFluentImpl<PipelineRunSpecFluent.ResultsNested<N>> implements PipelineRunSpecFluent.ResultsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ResultsBuilder builder;
    
            ResultsNestedImpl(Results item){
                    this.builder = new ResultsBuilder(this, item);
            }
            ResultsNestedImpl(){
                    this.builder = new ResultsBuilder(this);
            }
    
    public N and(){
            return (N) PipelineRunSpecFluentImpl.this.withResults(builder.build());
    }
    public N endResults(){
            return and();
    }

}
    public class ServiceAccountsNestedImpl<N> extends PipelineRunSpecServiceAccountFluentImpl<PipelineRunSpecFluent.ServiceAccountsNested<N>> implements PipelineRunSpecFluent.ServiceAccountsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PipelineRunSpecServiceAccountBuilder builder;
        private final int index;
    
            ServiceAccountsNestedImpl(int index,PipelineRunSpecServiceAccount item){
                    this.index = index;
                    this.builder = new PipelineRunSpecServiceAccountBuilder(this, item);
            }
            ServiceAccountsNestedImpl(){
                    this.index = -1;
                    this.builder = new PipelineRunSpecServiceAccountBuilder(this);
            }
    
    public N and(){
            return (N) PipelineRunSpecFluentImpl.this.setToServiceAccounts(index, builder.build());
    }
    public N endServiceAccount(){
            return and();
    }

}


}
