package io.fabric8.tekton.pipeline.v1alpha1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class PipelineRunSpecServiceAccountFluentImpl<A extends PipelineRunSpecServiceAccountFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PipelineRunSpecServiceAccountFluent<A>{

    private String serviceAccount;
    private String taskName;

    public PipelineRunSpecServiceAccountFluentImpl(){
    }
    public PipelineRunSpecServiceAccountFluentImpl(PipelineRunSpecServiceAccount instance){
            this.withServiceAccount(instance.getServiceAccount()); 
            this.withTaskName(instance.getTaskName()); 
    }

    public String getServiceAccount(){
            return this.serviceAccount;
    }

    public A withServiceAccount(String serviceAccount){
            this.serviceAccount=serviceAccount; return (A) this;
    }

    public Boolean hasServiceAccount(){
            return this.serviceAccount != null;
    }

    public A withNewServiceAccount(String arg1){
            return (A)withServiceAccount(new String(arg1));
    }

    public A withNewServiceAccount(StringBuilder arg1){
            return (A)withServiceAccount(new String(arg1));
    }

    public A withNewServiceAccount(StringBuffer arg1){
            return (A)withServiceAccount(new String(arg1));
    }

    public String getTaskName(){
            return this.taskName;
    }

    public A withTaskName(String taskName){
            this.taskName=taskName; return (A) this;
    }

    public Boolean hasTaskName(){
            return this.taskName != null;
    }

    public A withNewTaskName(String arg1){
            return (A)withTaskName(new String(arg1));
    }

    public A withNewTaskName(StringBuilder arg1){
            return (A)withTaskName(new String(arg1));
    }

    public A withNewTaskName(StringBuffer arg1){
            return (A)withTaskName(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PipelineRunSpecServiceAccountFluentImpl that = (PipelineRunSpecServiceAccountFluentImpl) o;
            if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
            if (taskName != null ? !taskName.equals(that.taskName) :that.taskName != null) return false;
            return true;
    }




}
