package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class PipelineRunStatusBuilder extends PipelineRunStatusFluentImpl<PipelineRunStatusBuilder> implements VisitableBuilder<PipelineRunStatus,PipelineRunStatusBuilder>{

    PipelineRunStatusFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PipelineRunStatusBuilder(){
            this(true);
    }
    public PipelineRunStatusBuilder(Boolean validationEnabled){
            this(new PipelineRunStatus(), validationEnabled);
    }
    public PipelineRunStatusBuilder(PipelineRunStatusFluent<?> fluent){
            this(fluent, true);
    }
    public PipelineRunStatusBuilder(PipelineRunStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PipelineRunStatus(), validationEnabled);
    }
    public PipelineRunStatusBuilder(PipelineRunStatusFluent<?> fluent,PipelineRunStatus instance){
            this(fluent, instance, true);
    }
    public PipelineRunStatusBuilder(PipelineRunStatusFluent<?> fluent,PipelineRunStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCompletionTime(instance.getCompletionTime()); 
            fluent.withConditions(instance.getConditions()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            fluent.withResults(instance.getResults()); 
            fluent.withStartTime(instance.getStartTime()); 
            fluent.withTaskRuns(instance.getTaskRuns()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineRunStatusBuilder(PipelineRunStatus instance){
            this(instance,true);
    }
    public PipelineRunStatusBuilder(PipelineRunStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCompletionTime(instance.getCompletionTime()); 
            this.withConditions(instance.getConditions()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withResults(instance.getResults()); 
            this.withStartTime(instance.getStartTime()); 
            this.withTaskRuns(instance.getTaskRuns()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineRunStatusBuilder(Validator validator){
            this(new PipelineRunStatus(), true);
    }
    public PipelineRunStatusBuilder(PipelineRunStatusFluent<?> fluent,PipelineRunStatus instance,Validator validator){
            this.fluent = fluent; 
            fluent.withCompletionTime(instance.getCompletionTime()); 
            fluent.withConditions(instance.getConditions()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            fluent.withResults(instance.getResults()); 
            fluent.withStartTime(instance.getStartTime()); 
            fluent.withTaskRuns(instance.getTaskRuns()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public PipelineRunStatusBuilder(PipelineRunStatus instance,Validator validator){
            this.fluent = this; 
            this.withCompletionTime(instance.getCompletionTime()); 
            this.withConditions(instance.getConditions()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withResults(instance.getResults()); 
            this.withStartTime(instance.getStartTime()); 
            this.withTaskRuns(instance.getTaskRuns()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public PipelineRunStatus build(){
            PipelineRunStatus buildable = new PipelineRunStatus(fluent.getCompletionTime(),fluent.getConditions(),fluent.getObservedGeneration(),fluent.getResults(),fluent.getStartTime(),fluent.getTaskRuns());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PipelineRunStatusBuilder that = (PipelineRunStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
