package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.v1.Condition;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import javax.validation.Valid;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface PipelineRunStatusFluent<A extends PipelineRunStatusFluent<A>> extends Fluent<A>{


    public String getCompletionTime();
    public A withCompletionTime(String completionTime);
    public Boolean hasCompletionTime();
    public A withNewCompletionTime(String arg1);
    public A withNewCompletionTime(StringBuilder arg1);
    public A withNewCompletionTime(StringBuffer arg1);
    public A addToConditions(int index,Condition item);
    public A setToConditions(int index,Condition item);
    public A addToConditions(Condition... items);
    public A addAllToConditions(Collection<Condition> items);
    public A removeFromConditions(Condition... items);
    public A removeAllFromConditions(Collection<Condition> items);
    public List<Condition> getConditions();
    public Condition getCondition(int index);
    public Condition getFirstCondition();
    public Condition getLastCondition();
    public Condition getMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<Condition> predicate);
    public Boolean hasMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<Condition> predicate);
    public A withConditions(List<Condition> conditions);
    public A withConditions(Condition... conditions);
    public Boolean hasConditions();
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    
/**
 * This method has been deprecated, please use method buildResults instead.
 * @return The buildable object.
 */
@Deprecated public Results getResults();
    public Results buildResults();
    public A withResults(Results results);
    public Boolean hasResults();
    public A withNewResults(String type,String url);
    public PipelineRunStatusFluent.ResultsNested<A> withNewResults();
    public PipelineRunStatusFluent.ResultsNested<A> withNewResultsLike(Results item);
    public PipelineRunStatusFluent.ResultsNested<A> editResults();
    public PipelineRunStatusFluent.ResultsNested<A> editOrNewResults();
    public PipelineRunStatusFluent.ResultsNested<A> editOrNewResultsLike(Results item);
    public String getStartTime();
    public A withStartTime(String startTime);
    public Boolean hasStartTime();
    public A withNewStartTime(String arg1);
    public A withNewStartTime(StringBuilder arg1);
    public A withNewStartTime(StringBuffer arg1);
    public A addToTaskRuns(String key,PipelineRunTaskRunStatus value);
    public A addToTaskRuns(Map<String,PipelineRunTaskRunStatus> map);
    public A removeFromTaskRuns(String key);
    public A removeFromTaskRuns(Map<String,PipelineRunTaskRunStatus> map);
    public Map<String,PipelineRunTaskRunStatus> getTaskRuns();
    public A withTaskRuns(Map<String,PipelineRunTaskRunStatus> taskRuns);
    public Boolean hasTaskRuns();

    public interface ResultsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ResultsFluent<PipelineRunStatusFluent.ResultsNested<N>>{

        
    public N and();    public N endResults();
}


}
