package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.v1.Condition;
import java.lang.StringBuffer;
import javax.validation.Valid;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class PipelineRunStatusFluentImpl<A extends PipelineRunStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PipelineRunStatusFluent<A>{

    private String completionTime;
    private List<Condition> conditions;
    private Long observedGeneration;
    private ResultsBuilder results;
    private String startTime;
    private Map<String,PipelineRunTaskRunStatus> taskRuns;

    public PipelineRunStatusFluentImpl(){
    }
    public PipelineRunStatusFluentImpl(PipelineRunStatus instance){
            this.withCompletionTime(instance.getCompletionTime()); 
            this.withConditions(instance.getConditions()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withResults(instance.getResults()); 
            this.withStartTime(instance.getStartTime()); 
            this.withTaskRuns(instance.getTaskRuns()); 
    }

    public String getCompletionTime(){
            return this.completionTime;
    }

    public A withCompletionTime(String completionTime){
            this.completionTime=completionTime; return (A) this;
    }

    public Boolean hasCompletionTime(){
            return this.completionTime != null;
    }

    public A withNewCompletionTime(String arg1){
            return (A)withCompletionTime(new String(arg1));
    }

    public A withNewCompletionTime(StringBuilder arg1){
            return (A)withCompletionTime(new String(arg1));
    }

    public A withNewCompletionTime(StringBuffer arg1){
            return (A)withCompletionTime(new String(arg1));
    }

    public A addToConditions(int index,Condition item){
            if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
            this.conditions.add(index, item);
            return (A)this;
    }

    public A setToConditions(int index,Condition item){
            if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
            this.conditions.set(index, item); return (A)this;
    }

    public A addToConditions(Condition... items){
            if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
            for (Condition item : items) {this.conditions.add(item);} return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items){
            if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
            for (Condition item : items) {this.conditions.add(item);} return (A)this;
    }

    public A removeFromConditions(Condition... items){
            for (Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items){
            for (Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
    }

    public List<Condition> getConditions(){
            return this.conditions;
    }

    public Condition getCondition(int index){
            return this.conditions.get(index);
    }

    public Condition getFirstCondition(){
            return this.conditions.get(0);
    }

    public Condition getLastCondition(){
            return this.conditions.get(conditions.size() - 1);
    }

    public Condition getMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<Condition> predicate){
            for (Condition item: conditions) { if(predicate.apply(item)){return item;} } return null;
    }

    public Boolean hasMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<Condition> predicate){
            for (Condition item: conditions) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withConditions(List<Condition> conditions){
            if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
            if (conditions != null) {this.conditions = new ArrayList<Condition>(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = new ArrayList<Condition>();} return (A) this;
    }

    public A withConditions(Condition... conditions){
            if (this.conditions != null) {this.conditions.clear();}
            if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions(){
            return conditions != null && !conditions.isEmpty();
    }

    public Long getObservedGeneration(){
            return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration){
            this.observedGeneration=observedGeneration; return (A) this;
    }

    public Boolean hasObservedGeneration(){
            return this.observedGeneration != null;
    }

    
/**
 * This method has been deprecated, please use method buildResults instead.
 * @return The buildable object.
 */
@Deprecated public Results getResults(){
            return this.results!=null?this.results.build():null;
    }

    public Results buildResults(){
            return this.results!=null?this.results.build():null;
    }

    public A withResults(Results results){
            _visitables.get("results").remove(this.results);
            if (results!=null){ this.results= new ResultsBuilder(results); _visitables.get("results").add(this.results);} return (A) this;
    }

    public Boolean hasResults(){
            return this.results != null;
    }

    public A withNewResults(String type,String url){
            return (A)withResults(new Results(type, url));
    }

    public PipelineRunStatusFluent.ResultsNested<A> withNewResults(){
            return new ResultsNestedImpl();
    }

    public PipelineRunStatusFluent.ResultsNested<A> withNewResultsLike(Results item){
            return new ResultsNestedImpl(item);
    }

    public PipelineRunStatusFluent.ResultsNested<A> editResults(){
            return withNewResultsLike(getResults());
    }

    public PipelineRunStatusFluent.ResultsNested<A> editOrNewResults(){
            return withNewResultsLike(getResults() != null ? getResults(): new ResultsBuilder().build());
    }

    public PipelineRunStatusFluent.ResultsNested<A> editOrNewResultsLike(Results item){
            return withNewResultsLike(getResults() != null ? getResults(): item);
    }

    public String getStartTime(){
            return this.startTime;
    }

    public A withStartTime(String startTime){
            this.startTime=startTime; return (A) this;
    }

    public Boolean hasStartTime(){
            return this.startTime != null;
    }

    public A withNewStartTime(String arg1){
            return (A)withStartTime(new String(arg1));
    }

    public A withNewStartTime(StringBuilder arg1){
            return (A)withStartTime(new String(arg1));
    }

    public A withNewStartTime(StringBuffer arg1){
            return (A)withStartTime(new String(arg1));
    }

    public A addToTaskRuns(String key,PipelineRunTaskRunStatus value){
            if(this.taskRuns == null && key != null && value != null) { this.taskRuns = new LinkedHashMap<String,PipelineRunTaskRunStatus>(); }
            if(key != null && value != null) {this.taskRuns.put(key, value);} return (A)this;
    }

    public A addToTaskRuns(Map<String,PipelineRunTaskRunStatus> map){
            if(this.taskRuns == null && map != null) { this.taskRuns = new LinkedHashMap<String,PipelineRunTaskRunStatus>(); }
            if(map != null) { this.taskRuns.putAll(map);} return (A)this;
    }

    public A removeFromTaskRuns(String key){
            if(this.taskRuns == null) { return (A) this; }
            if(key != null && this.taskRuns != null) {this.taskRuns.remove(key);} return (A)this;
    }

    public A removeFromTaskRuns(Map<String,PipelineRunTaskRunStatus> map){
            if(this.taskRuns == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.taskRuns != null){this.taskRuns.remove(key);}}} return (A)this;
    }

    public Map<String,PipelineRunTaskRunStatus> getTaskRuns(){
            return this.taskRuns;
    }

    public A withTaskRuns(Map<String,PipelineRunTaskRunStatus> taskRuns){
            if (taskRuns == null) { this.taskRuns =  new LinkedHashMap<String,PipelineRunTaskRunStatus>();} else {this.taskRuns = new LinkedHashMap<String,PipelineRunTaskRunStatus>(taskRuns);} return (A) this;
    }

    public Boolean hasTaskRuns(){
            return this.taskRuns != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PipelineRunStatusFluentImpl that = (PipelineRunStatusFluentImpl) o;
            if (completionTime != null ? !completionTime.equals(that.completionTime) :that.completionTime != null) return false;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
            if (results != null ? !results.equals(that.results) :that.results != null) return false;
            if (startTime != null ? !startTime.equals(that.startTime) :that.startTime != null) return false;
            if (taskRuns != null ? !taskRuns.equals(that.taskRuns) :that.taskRuns != null) return false;
            return true;
    }


    public class ResultsNestedImpl<N> extends ResultsFluentImpl<PipelineRunStatusFluent.ResultsNested<N>> implements PipelineRunStatusFluent.ResultsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ResultsBuilder builder;
    
            ResultsNestedImpl(Results item){
                    this.builder = new ResultsBuilder(this, item);
            }
            ResultsNestedImpl(){
                    this.builder = new ResultsBuilder(this);
            }
    
    public N and(){
            return (N) PipelineRunStatusFluentImpl.this.withResults(builder.build());
    }
    public N endResults(){
            return and();
    }

}


}
