package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class PipelineRunTaskRunStatusBuilder extends PipelineRunTaskRunStatusFluentImpl<PipelineRunTaskRunStatusBuilder> implements VisitableBuilder<PipelineRunTaskRunStatus,PipelineRunTaskRunStatusBuilder>{

    PipelineRunTaskRunStatusFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PipelineRunTaskRunStatusBuilder(){
            this(true);
    }
    public PipelineRunTaskRunStatusBuilder(Boolean validationEnabled){
            this(new PipelineRunTaskRunStatus(), validationEnabled);
    }
    public PipelineRunTaskRunStatusBuilder(PipelineRunTaskRunStatusFluent<?> fluent){
            this(fluent, true);
    }
    public PipelineRunTaskRunStatusBuilder(PipelineRunTaskRunStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PipelineRunTaskRunStatus(), validationEnabled);
    }
    public PipelineRunTaskRunStatusBuilder(PipelineRunTaskRunStatusFluent<?> fluent,PipelineRunTaskRunStatus instance){
            this(fluent, instance, true);
    }
    public PipelineRunTaskRunStatusBuilder(PipelineRunTaskRunStatusFluent<?> fluent,PipelineRunTaskRunStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPipelineTaskName(instance.getPipelineTaskName()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineRunTaskRunStatusBuilder(PipelineRunTaskRunStatus instance){
            this(instance,true);
    }
    public PipelineRunTaskRunStatusBuilder(PipelineRunTaskRunStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPipelineTaskName(instance.getPipelineTaskName()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineRunTaskRunStatusBuilder(Validator validator){
            this(new PipelineRunTaskRunStatus(), true);
    }
    public PipelineRunTaskRunStatusBuilder(PipelineRunTaskRunStatusFluent<?> fluent,PipelineRunTaskRunStatus instance,Validator validator){
            this.fluent = fluent; 
            fluent.withPipelineTaskName(instance.getPipelineTaskName()); 
            fluent.withStatus(instance.getStatus()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public PipelineRunTaskRunStatusBuilder(PipelineRunTaskRunStatus instance,Validator validator){
            this.fluent = this; 
            this.withPipelineTaskName(instance.getPipelineTaskName()); 
            this.withStatus(instance.getStatus()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public PipelineRunTaskRunStatus build(){
            PipelineRunTaskRunStatus buildable = new PipelineRunTaskRunStatus(fluent.getPipelineTaskName(),fluent.getStatus());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PipelineRunTaskRunStatusBuilder that = (PipelineRunTaskRunStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
