package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;

public class PipelineSpecFluentImpl<A extends PipelineSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PipelineSpecFluent<A>{

    private List<ParamSpecBuilder> params;
    private List<PipelineDeclaredResourceBuilder> resources;
    private List<PipelineTaskBuilder> tasks;

    public PipelineSpecFluentImpl(){
    }
    public PipelineSpecFluentImpl(PipelineSpec instance){
            this.withParams(instance.getParams()); 
            this.withResources(instance.getResources()); 
            this.withTasks(instance.getTasks()); 
    }

    public A addToParams(int index,ParamSpec item){
            if (this.params == null) {this.params = new ArrayList<ParamSpecBuilder>();}
            ParamSpecBuilder builder = new ParamSpecBuilder(item);_visitables.get("params").add(index >= 0 ? index : _visitables.get("params").size(), builder);this.params.add(index >= 0 ? index : params.size(), builder); return (A)this;
    }

    public A setToParams(int index,ParamSpec item){
            if (this.params == null) {this.params = new ArrayList<ParamSpecBuilder>();}
            ParamSpecBuilder builder = new ParamSpecBuilder(item);
            if (index < 0 || index >= _visitables.get("params").size()) { _visitables.get("params").add(builder); } else { _visitables.get("params").set(index, builder);}
            if (index < 0 || index >= params.size()) { params.add(builder); } else { params.set(index, builder);}
             return (A)this;
    }

    public A addToParams(ParamSpec... items){
            if (this.params == null) {this.params = new ArrayList<ParamSpecBuilder>();}
            for (ParamSpec item : items) {ParamSpecBuilder builder = new ParamSpecBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
    }

    public A addAllToParams(Collection<ParamSpec> items){
            if (this.params == null) {this.params = new ArrayList<ParamSpecBuilder>();}
            for (ParamSpec item : items) {ParamSpecBuilder builder = new ParamSpecBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
    }

    public A removeFromParams(ParamSpec... items){
            for (ParamSpec item : items) {ParamSpecBuilder builder = new ParamSpecBuilder(item);_visitables.get("params").remove(builder);if (this.params != null) {this.params.remove(builder);}} return (A)this;
    }

    public A removeAllFromParams(Collection<ParamSpec> items){
            for (ParamSpec item : items) {ParamSpecBuilder builder = new ParamSpecBuilder(item);_visitables.get("params").remove(builder);if (this.params != null) {this.params.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildParams instead.
 * @return The buildable object.
 */
@Deprecated public List<ParamSpec> getParams(){
            return build(params);
    }

    public List<ParamSpec> buildParams(){
            return build(params);
    }

    public ParamSpec buildParam(int index){
            return this.params.get(index).build();
    }

    public ParamSpec buildFirstParam(){
            return this.params.get(0).build();
    }

    public ParamSpec buildLastParam(){
            return this.params.get(params.size() - 1).build();
    }

    public ParamSpec buildMatchingParam(io.fabric8.kubernetes.api.builder.Predicate<ParamSpecBuilder> predicate){
            for (ParamSpecBuilder item: params) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingParam(io.fabric8.kubernetes.api.builder.Predicate<ParamSpecBuilder> predicate){
            for (ParamSpecBuilder item: params) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withParams(List<ParamSpec> params){
            if (this.params != null) { _visitables.get("params").removeAll(this.params);}
            if (params != null) {this.params = new ArrayList<ParamSpecBuilder>(); for (ParamSpec item : params){this.addToParams(item);}} else { this.params = new ArrayList<ParamSpecBuilder>();} return (A) this;
    }

    public A withParams(ParamSpec... params){
            if (this.params != null) {this.params.clear();}
            if (params != null) {for (ParamSpec item :params){ this.addToParams(item);}} return (A) this;
    }

    public Boolean hasParams(){
            return params != null && !params.isEmpty();
    }

    public A addNewParam(String _default,String description,String name){
            return (A)addToParams(new ParamSpec(_default, description, name));
    }

    public PipelineSpecFluent.ParamsNested<A> addNewParam(){
            return new ParamsNestedImpl();
    }

    public PipelineSpecFluent.ParamsNested<A> addNewParamLike(ParamSpec item){
            return new ParamsNestedImpl(-1, item);
    }

    public PipelineSpecFluent.ParamsNested<A> setNewParamLike(int index,ParamSpec item){
            return new ParamsNestedImpl(index, item);
    }

    public PipelineSpecFluent.ParamsNested<A> editParam(int index){
            if (params.size() <= index) throw new RuntimeException("Can't edit params. Index exceeds size.");
            return setNewParamLike(index, buildParam(index));
    }

    public PipelineSpecFluent.ParamsNested<A> editFirstParam(){
            if (params.size() == 0) throw new RuntimeException("Can't edit first params. The list is empty.");
            return setNewParamLike(0, buildParam(0));
    }

    public PipelineSpecFluent.ParamsNested<A> editLastParam(){
            int index = params.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last params. The list is empty.");
            return setNewParamLike(index, buildParam(index));
    }

    public PipelineSpecFluent.ParamsNested<A> editMatchingParam(io.fabric8.kubernetes.api.builder.Predicate<ParamSpecBuilder> predicate){
            int index = -1;
            for (int i=0;i<params.size();i++) { 
            if (predicate.apply(params.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching params. No match found.");
            return setNewParamLike(index, buildParam(index));
    }

    public A addToResources(int index,PipelineDeclaredResource item){
            if (this.resources == null) {this.resources = new ArrayList<PipelineDeclaredResourceBuilder>();}
            PipelineDeclaredResourceBuilder builder = new PipelineDeclaredResourceBuilder(item);_visitables.get("resources").add(index >= 0 ? index : _visitables.get("resources").size(), builder);this.resources.add(index >= 0 ? index : resources.size(), builder); return (A)this;
    }

    public A setToResources(int index,PipelineDeclaredResource item){
            if (this.resources == null) {this.resources = new ArrayList<PipelineDeclaredResourceBuilder>();}
            PipelineDeclaredResourceBuilder builder = new PipelineDeclaredResourceBuilder(item);
            if (index < 0 || index >= _visitables.get("resources").size()) { _visitables.get("resources").add(builder); } else { _visitables.get("resources").set(index, builder);}
            if (index < 0 || index >= resources.size()) { resources.add(builder); } else { resources.set(index, builder);}
             return (A)this;
    }

    public A addToResources(PipelineDeclaredResource... items){
            if (this.resources == null) {this.resources = new ArrayList<PipelineDeclaredResourceBuilder>();}
            for (PipelineDeclaredResource item : items) {PipelineDeclaredResourceBuilder builder = new PipelineDeclaredResourceBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
    }

    public A addAllToResources(Collection<PipelineDeclaredResource> items){
            if (this.resources == null) {this.resources = new ArrayList<PipelineDeclaredResourceBuilder>();}
            for (PipelineDeclaredResource item : items) {PipelineDeclaredResourceBuilder builder = new PipelineDeclaredResourceBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
    }

    public A removeFromResources(PipelineDeclaredResource... items){
            for (PipelineDeclaredResource item : items) {PipelineDeclaredResourceBuilder builder = new PipelineDeclaredResourceBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
    }

    public A removeAllFromResources(Collection<PipelineDeclaredResource> items){
            for (PipelineDeclaredResource item : items) {PipelineDeclaredResourceBuilder builder = new PipelineDeclaredResourceBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public List<PipelineDeclaredResource> getResources(){
            return build(resources);
    }

    public List<PipelineDeclaredResource> buildResources(){
            return build(resources);
    }

    public PipelineDeclaredResource buildResource(int index){
            return this.resources.get(index).build();
    }

    public PipelineDeclaredResource buildFirstResource(){
            return this.resources.get(0).build();
    }

    public PipelineDeclaredResource buildLastResource(){
            return this.resources.get(resources.size() - 1).build();
    }

    public PipelineDeclaredResource buildMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<PipelineDeclaredResourceBuilder> predicate){
            for (PipelineDeclaredResourceBuilder item: resources) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<PipelineDeclaredResourceBuilder> predicate){
            for (PipelineDeclaredResourceBuilder item: resources) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withResources(List<PipelineDeclaredResource> resources){
            if (this.resources != null) { _visitables.get("resources").removeAll(this.resources);}
            if (resources != null) {this.resources = new ArrayList<PipelineDeclaredResourceBuilder>(); for (PipelineDeclaredResource item : resources){this.addToResources(item);}} else { this.resources = new ArrayList<PipelineDeclaredResourceBuilder>();} return (A) this;
    }

    public A withResources(PipelineDeclaredResource... resources){
            if (this.resources != null) {this.resources.clear();}
            if (resources != null) {for (PipelineDeclaredResource item :resources){ this.addToResources(item);}} return (A) this;
    }

    public Boolean hasResources(){
            return resources != null && !resources.isEmpty();
    }

    public A addNewResource(String name,String type){
            return (A)addToResources(new PipelineDeclaredResource(name, type));
    }

    public PipelineSpecFluent.ResourcesNested<A> addNewResource(){
            return new ResourcesNestedImpl();
    }

    public PipelineSpecFluent.ResourcesNested<A> addNewResourceLike(PipelineDeclaredResource item){
            return new ResourcesNestedImpl(-1, item);
    }

    public PipelineSpecFluent.ResourcesNested<A> setNewResourceLike(int index,PipelineDeclaredResource item){
            return new ResourcesNestedImpl(index, item);
    }

    public PipelineSpecFluent.ResourcesNested<A> editResource(int index){
            if (resources.size() <= index) throw new RuntimeException("Can't edit resources. Index exceeds size.");
            return setNewResourceLike(index, buildResource(index));
    }

    public PipelineSpecFluent.ResourcesNested<A> editFirstResource(){
            if (resources.size() == 0) throw new RuntimeException("Can't edit first resources. The list is empty.");
            return setNewResourceLike(0, buildResource(0));
    }

    public PipelineSpecFluent.ResourcesNested<A> editLastResource(){
            int index = resources.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last resources. The list is empty.");
            return setNewResourceLike(index, buildResource(index));
    }

    public PipelineSpecFluent.ResourcesNested<A> editMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<PipelineDeclaredResourceBuilder> predicate){
            int index = -1;
            for (int i=0;i<resources.size();i++) { 
            if (predicate.apply(resources.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching resources. No match found.");
            return setNewResourceLike(index, buildResource(index));
    }

    public A addToTasks(int index,PipelineTask item){
            if (this.tasks == null) {this.tasks = new ArrayList<PipelineTaskBuilder>();}
            PipelineTaskBuilder builder = new PipelineTaskBuilder(item);_visitables.get("tasks").add(index >= 0 ? index : _visitables.get("tasks").size(), builder);this.tasks.add(index >= 0 ? index : tasks.size(), builder); return (A)this;
    }

    public A setToTasks(int index,PipelineTask item){
            if (this.tasks == null) {this.tasks = new ArrayList<PipelineTaskBuilder>();}
            PipelineTaskBuilder builder = new PipelineTaskBuilder(item);
            if (index < 0 || index >= _visitables.get("tasks").size()) { _visitables.get("tasks").add(builder); } else { _visitables.get("tasks").set(index, builder);}
            if (index < 0 || index >= tasks.size()) { tasks.add(builder); } else { tasks.set(index, builder);}
             return (A)this;
    }

    public A addToTasks(PipelineTask... items){
            if (this.tasks == null) {this.tasks = new ArrayList<PipelineTaskBuilder>();}
            for (PipelineTask item : items) {PipelineTaskBuilder builder = new PipelineTaskBuilder(item);_visitables.get("tasks").add(builder);this.tasks.add(builder);} return (A)this;
    }

    public A addAllToTasks(Collection<PipelineTask> items){
            if (this.tasks == null) {this.tasks = new ArrayList<PipelineTaskBuilder>();}
            for (PipelineTask item : items) {PipelineTaskBuilder builder = new PipelineTaskBuilder(item);_visitables.get("tasks").add(builder);this.tasks.add(builder);} return (A)this;
    }

    public A removeFromTasks(PipelineTask... items){
            for (PipelineTask item : items) {PipelineTaskBuilder builder = new PipelineTaskBuilder(item);_visitables.get("tasks").remove(builder);if (this.tasks != null) {this.tasks.remove(builder);}} return (A)this;
    }

    public A removeAllFromTasks(Collection<PipelineTask> items){
            for (PipelineTask item : items) {PipelineTaskBuilder builder = new PipelineTaskBuilder(item);_visitables.get("tasks").remove(builder);if (this.tasks != null) {this.tasks.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTasks instead.
 * @return The buildable object.
 */
@Deprecated public List<PipelineTask> getTasks(){
            return build(tasks);
    }

    public List<PipelineTask> buildTasks(){
            return build(tasks);
    }

    public PipelineTask buildTask(int index){
            return this.tasks.get(index).build();
    }

    public PipelineTask buildFirstTask(){
            return this.tasks.get(0).build();
    }

    public PipelineTask buildLastTask(){
            return this.tasks.get(tasks.size() - 1).build();
    }

    public PipelineTask buildMatchingTask(io.fabric8.kubernetes.api.builder.Predicate<PipelineTaskBuilder> predicate){
            for (PipelineTaskBuilder item: tasks) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingTask(io.fabric8.kubernetes.api.builder.Predicate<PipelineTaskBuilder> predicate){
            for (PipelineTaskBuilder item: tasks) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withTasks(List<PipelineTask> tasks){
            if (this.tasks != null) { _visitables.get("tasks").removeAll(this.tasks);}
            if (tasks != null) {this.tasks = new ArrayList<PipelineTaskBuilder>(); for (PipelineTask item : tasks){this.addToTasks(item);}} else { this.tasks = new ArrayList<PipelineTaskBuilder>();} return (A) this;
    }

    public A withTasks(PipelineTask... tasks){
            if (this.tasks != null) {this.tasks.clear();}
            if (tasks != null) {for (PipelineTask item :tasks){ this.addToTasks(item);}} return (A) this;
    }

    public Boolean hasTasks(){
            return tasks != null && !tasks.isEmpty();
    }

    public PipelineSpecFluent.TasksNested<A> addNewTask(){
            return new TasksNestedImpl();
    }

    public PipelineSpecFluent.TasksNested<A> addNewTaskLike(PipelineTask item){
            return new TasksNestedImpl(-1, item);
    }

    public PipelineSpecFluent.TasksNested<A> setNewTaskLike(int index,PipelineTask item){
            return new TasksNestedImpl(index, item);
    }

    public PipelineSpecFluent.TasksNested<A> editTask(int index){
            if (tasks.size() <= index) throw new RuntimeException("Can't edit tasks. Index exceeds size.");
            return setNewTaskLike(index, buildTask(index));
    }

    public PipelineSpecFluent.TasksNested<A> editFirstTask(){
            if (tasks.size() == 0) throw new RuntimeException("Can't edit first tasks. The list is empty.");
            return setNewTaskLike(0, buildTask(0));
    }

    public PipelineSpecFluent.TasksNested<A> editLastTask(){
            int index = tasks.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last tasks. The list is empty.");
            return setNewTaskLike(index, buildTask(index));
    }

    public PipelineSpecFluent.TasksNested<A> editMatchingTask(io.fabric8.kubernetes.api.builder.Predicate<PipelineTaskBuilder> predicate){
            int index = -1;
            for (int i=0;i<tasks.size();i++) { 
            if (predicate.apply(tasks.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching tasks. No match found.");
            return setNewTaskLike(index, buildTask(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PipelineSpecFluentImpl that = (PipelineSpecFluentImpl) o;
            if (params != null ? !params.equals(that.params) :that.params != null) return false;
            if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
            if (tasks != null ? !tasks.equals(that.tasks) :that.tasks != null) return false;
            return true;
    }


    public class ParamsNestedImpl<N> extends ParamSpecFluentImpl<PipelineSpecFluent.ParamsNested<N>> implements PipelineSpecFluent.ParamsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ParamSpecBuilder builder;
        private final int index;
    
            ParamsNestedImpl(int index,ParamSpec item){
                    this.index = index;
                    this.builder = new ParamSpecBuilder(this, item);
            }
            ParamsNestedImpl(){
                    this.index = -1;
                    this.builder = new ParamSpecBuilder(this);
            }
    
    public N and(){
            return (N) PipelineSpecFluentImpl.this.setToParams(index, builder.build());
    }
    public N endParam(){
            return and();
    }

}
    public class ResourcesNestedImpl<N> extends PipelineDeclaredResourceFluentImpl<PipelineSpecFluent.ResourcesNested<N>> implements PipelineSpecFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PipelineDeclaredResourceBuilder builder;
        private final int index;
    
            ResourcesNestedImpl(int index,PipelineDeclaredResource item){
                    this.index = index;
                    this.builder = new PipelineDeclaredResourceBuilder(this, item);
            }
            ResourcesNestedImpl(){
                    this.index = -1;
                    this.builder = new PipelineDeclaredResourceBuilder(this);
            }
    
    public N and(){
            return (N) PipelineSpecFluentImpl.this.setToResources(index, builder.build());
    }
    public N endResource(){
            return and();
    }

}
    public class TasksNestedImpl<N> extends PipelineTaskFluentImpl<PipelineSpecFluent.TasksNested<N>> implements PipelineSpecFluent.TasksNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PipelineTaskBuilder builder;
        private final int index;
    
            TasksNestedImpl(int index,PipelineTask item){
                    this.index = index;
                    this.builder = new PipelineTaskBuilder(this, item);
            }
            TasksNestedImpl(){
                    this.index = -1;
                    this.builder = new PipelineTaskBuilder(this);
            }
    
    public N and(){
            return (N) PipelineSpecFluentImpl.this.setToTasks(index, builder.build());
    }
    public N endTask(){
            return and();
    }

}


}
