package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.lang.StringBuffer;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface PipelineTaskFluent<A extends PipelineTaskFluent<A>> extends Fluent<A>{


    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    public A addToParams(int index,Param item);
    public A setToParams(int index,Param item);
    public A addToParams(Param... items);
    public A addAllToParams(Collection<Param> items);
    public A removeFromParams(Param... items);
    public A removeAllFromParams(Collection<Param> items);
    
/**
 * This method has been deprecated, please use method buildParams instead.
 * @return The buildable object.
 */
@Deprecated public List<Param> getParams();
    public List<Param> buildParams();
    public Param buildParam(int index);
    public Param buildFirstParam();
    public Param buildLastParam();
    public Param buildMatchingParam(io.fabric8.kubernetes.api.builder.Predicate<ParamBuilder> predicate);
    public Boolean hasMatchingParam(io.fabric8.kubernetes.api.builder.Predicate<ParamBuilder> predicate);
    public A withParams(List<Param> params);
    public A withParams(Param... params);
    public Boolean hasParams();
    public A addNewParam(String name,String value);
    public PipelineTaskFluent.ParamsNested<A> addNewParam();
    public PipelineTaskFluent.ParamsNested<A> addNewParamLike(Param item);
    public PipelineTaskFluent.ParamsNested<A> setNewParamLike(int index,Param item);
    public PipelineTaskFluent.ParamsNested<A> editParam(int index);
    public PipelineTaskFluent.ParamsNested<A> editFirstParam();
    public PipelineTaskFluent.ParamsNested<A> editLastParam();
    public PipelineTaskFluent.ParamsNested<A> editMatchingParam(io.fabric8.kubernetes.api.builder.Predicate<ParamBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public PipelineTaskResources getResources();
    public PipelineTaskResources buildResources();
    public A withResources(PipelineTaskResources resources);
    public Boolean hasResources();
    public PipelineTaskFluent.ResourcesNested<A> withNewResources();
    public PipelineTaskFluent.ResourcesNested<A> withNewResourcesLike(PipelineTaskResources item);
    public PipelineTaskFluent.ResourcesNested<A> editResources();
    public PipelineTaskFluent.ResourcesNested<A> editOrNewResources();
    public PipelineTaskFluent.ResourcesNested<A> editOrNewResourcesLike(PipelineTaskResources item);
    public Integer getRetries();
    public A withRetries(Integer retries);
    public Boolean hasRetries();
    public A addToRunAfter(int index,String item);
    public A setToRunAfter(int index,String item);
    public A addToRunAfter(String... items);
    public A addAllToRunAfter(Collection<String> items);
    public A removeFromRunAfter(String... items);
    public A removeAllFromRunAfter(Collection<String> items);
    public List<String> getRunAfter();
    public String getRunAfter(int index);
    public String getFirstRunAfter();
    public String getLastRunAfter();
    public String getMatchingRunAfter(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingRunAfter(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withRunAfter(List<String> runAfter);
    public A withRunAfter(String... runAfter);
    public Boolean hasRunAfter();
    public A addNewRunAfter(String arg1);
    public A addNewRunAfter(StringBuilder arg1);
    public A addNewRunAfter(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildTaskRef instead.
 * @return The buildable object.
 */
@Deprecated public TaskRef getTaskRef();
    public TaskRef buildTaskRef();
    public A withTaskRef(TaskRef taskRef);
    public Boolean hasTaskRef();
    public A withNewTaskRef(String apiVersion,String kind,String name);
    public PipelineTaskFluent.TaskRefNested<A> withNewTaskRef();
    public PipelineTaskFluent.TaskRefNested<A> withNewTaskRefLike(TaskRef item);
    public PipelineTaskFluent.TaskRefNested<A> editTaskRef();
    public PipelineTaskFluent.TaskRefNested<A> editOrNewTaskRef();
    public PipelineTaskFluent.TaskRefNested<A> editOrNewTaskRefLike(TaskRef item);

    public interface ParamsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ParamFluent<PipelineTaskFluent.ParamsNested<N>>{

        
    public N and();    public N endParam();
}
    public interface ResourcesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PipelineTaskResourcesFluent<PipelineTaskFluent.ResourcesNested<N>>{

        
    public N and();    public N endResources();
}
    public interface TaskRefNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TaskRefFluent<PipelineTaskFluent.TaskRefNested<N>>{

        
    public N and();    public N endTaskRef();
}


}
