package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.StringBuffer;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;

public class PipelineTaskFluentImpl<A extends PipelineTaskFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PipelineTaskFluent<A>{

    private String name;
    private List<ParamBuilder> params;
    private PipelineTaskResourcesBuilder resources;
    private Integer retries;
    private List<String> runAfter;
    private TaskRefBuilder taskRef;

    public PipelineTaskFluentImpl(){
    }
    public PipelineTaskFluentImpl(PipelineTask instance){
            this.withName(instance.getName()); 
            this.withParams(instance.getParams()); 
            this.withResources(instance.getResources()); 
            this.withRetries(instance.getRetries()); 
            this.withRunAfter(instance.getRunAfter()); 
            this.withTaskRef(instance.getTaskRef()); 
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public A addToParams(int index,Param item){
            if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
            ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").add(index >= 0 ? index : _visitables.get("params").size(), builder);this.params.add(index >= 0 ? index : params.size(), builder); return (A)this;
    }

    public A setToParams(int index,Param item){
            if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
            ParamBuilder builder = new ParamBuilder(item);
            if (index < 0 || index >= _visitables.get("params").size()) { _visitables.get("params").add(builder); } else { _visitables.get("params").set(index, builder);}
            if (index < 0 || index >= params.size()) { params.add(builder); } else { params.set(index, builder);}
             return (A)this;
    }

    public A addToParams(Param... items){
            if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
            for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
    }

    public A addAllToParams(Collection<Param> items){
            if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
            for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
    }

    public A removeFromParams(Param... items){
            for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").remove(builder);if (this.params != null) {this.params.remove(builder);}} return (A)this;
    }

    public A removeAllFromParams(Collection<Param> items){
            for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").remove(builder);if (this.params != null) {this.params.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildParams instead.
 * @return The buildable object.
 */
@Deprecated public List<Param> getParams(){
            return build(params);
    }

    public List<Param> buildParams(){
            return build(params);
    }

    public Param buildParam(int index){
            return this.params.get(index).build();
    }

    public Param buildFirstParam(){
            return this.params.get(0).build();
    }

    public Param buildLastParam(){
            return this.params.get(params.size() - 1).build();
    }

    public Param buildMatchingParam(io.fabric8.kubernetes.api.builder.Predicate<ParamBuilder> predicate){
            for (ParamBuilder item: params) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingParam(io.fabric8.kubernetes.api.builder.Predicate<ParamBuilder> predicate){
            for (ParamBuilder item: params) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withParams(List<Param> params){
            if (this.params != null) { _visitables.get("params").removeAll(this.params);}
            if (params != null) {this.params = new ArrayList<ParamBuilder>(); for (Param item : params){this.addToParams(item);}} else { this.params = new ArrayList<ParamBuilder>();} return (A) this;
    }

    public A withParams(Param... params){
            if (this.params != null) {this.params.clear();}
            if (params != null) {for (Param item :params){ this.addToParams(item);}} return (A) this;
    }

    public Boolean hasParams(){
            return params != null && !params.isEmpty();
    }

    public A addNewParam(String name,String value){
            return (A)addToParams(new Param(name, value));
    }

    public PipelineTaskFluent.ParamsNested<A> addNewParam(){
            return new ParamsNestedImpl();
    }

    public PipelineTaskFluent.ParamsNested<A> addNewParamLike(Param item){
            return new ParamsNestedImpl(-1, item);
    }

    public PipelineTaskFluent.ParamsNested<A> setNewParamLike(int index,Param item){
            return new ParamsNestedImpl(index, item);
    }

    public PipelineTaskFluent.ParamsNested<A> editParam(int index){
            if (params.size() <= index) throw new RuntimeException("Can't edit params. Index exceeds size.");
            return setNewParamLike(index, buildParam(index));
    }

    public PipelineTaskFluent.ParamsNested<A> editFirstParam(){
            if (params.size() == 0) throw new RuntimeException("Can't edit first params. The list is empty.");
            return setNewParamLike(0, buildParam(0));
    }

    public PipelineTaskFluent.ParamsNested<A> editLastParam(){
            int index = params.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last params. The list is empty.");
            return setNewParamLike(index, buildParam(index));
    }

    public PipelineTaskFluent.ParamsNested<A> editMatchingParam(io.fabric8.kubernetes.api.builder.Predicate<ParamBuilder> predicate){
            int index = -1;
            for (int i=0;i<params.size();i++) { 
            if (predicate.apply(params.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching params. No match found.");
            return setNewParamLike(index, buildParam(index));
    }

    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public PipelineTaskResources getResources(){
            return this.resources!=null?this.resources.build():null;
    }

    public PipelineTaskResources buildResources(){
            return this.resources!=null?this.resources.build():null;
    }

    public A withResources(PipelineTaskResources resources){
            _visitables.get("resources").remove(this.resources);
            if (resources!=null){ this.resources= new PipelineTaskResourcesBuilder(resources); _visitables.get("resources").add(this.resources);} return (A) this;
    }

    public Boolean hasResources(){
            return this.resources != null;
    }

    public PipelineTaskFluent.ResourcesNested<A> withNewResources(){
            return new ResourcesNestedImpl();
    }

    public PipelineTaskFluent.ResourcesNested<A> withNewResourcesLike(PipelineTaskResources item){
            return new ResourcesNestedImpl(item);
    }

    public PipelineTaskFluent.ResourcesNested<A> editResources(){
            return withNewResourcesLike(getResources());
    }

    public PipelineTaskFluent.ResourcesNested<A> editOrNewResources(){
            return withNewResourcesLike(getResources() != null ? getResources(): new PipelineTaskResourcesBuilder().build());
    }

    public PipelineTaskFluent.ResourcesNested<A> editOrNewResourcesLike(PipelineTaskResources item){
            return withNewResourcesLike(getResources() != null ? getResources(): item);
    }

    public Integer getRetries(){
            return this.retries;
    }

    public A withRetries(Integer retries){
            this.retries=retries; return (A) this;
    }

    public Boolean hasRetries(){
            return this.retries != null;
    }

    public A addToRunAfter(int index,String item){
            if (this.runAfter == null) {this.runAfter = new ArrayList<String>();}
            this.runAfter.add(index, item);
            return (A)this;
    }

    public A setToRunAfter(int index,String item){
            if (this.runAfter == null) {this.runAfter = new ArrayList<String>();}
            this.runAfter.set(index, item); return (A)this;
    }

    public A addToRunAfter(String... items){
            if (this.runAfter == null) {this.runAfter = new ArrayList<String>();}
            for (String item : items) {this.runAfter.add(item);} return (A)this;
    }

    public A addAllToRunAfter(Collection<String> items){
            if (this.runAfter == null) {this.runAfter = new ArrayList<String>();}
            for (String item : items) {this.runAfter.add(item);} return (A)this;
    }

    public A removeFromRunAfter(String... items){
            for (String item : items) {if (this.runAfter!= null){ this.runAfter.remove(item);}} return (A)this;
    }

    public A removeAllFromRunAfter(Collection<String> items){
            for (String item : items) {if (this.runAfter!= null){ this.runAfter.remove(item);}} return (A)this;
    }

    public List<String> getRunAfter(){
            return this.runAfter;
    }

    public String getRunAfter(int index){
            return this.runAfter.get(index);
    }

    public String getFirstRunAfter(){
            return this.runAfter.get(0);
    }

    public String getLastRunAfter(){
            return this.runAfter.get(runAfter.size() - 1);
    }

    public String getMatchingRunAfter(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: runAfter) { if(predicate.apply(item)){return item;} } return null;
    }

    public Boolean hasMatchingRunAfter(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: runAfter) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withRunAfter(List<String> runAfter){
            if (this.runAfter != null) { _visitables.get("runAfter").removeAll(this.runAfter);}
            if (runAfter != null) {this.runAfter = new ArrayList<String>(); for (String item : runAfter){this.addToRunAfter(item);}} else { this.runAfter = new ArrayList<String>();} return (A) this;
    }

    public A withRunAfter(String... runAfter){
            if (this.runAfter != null) {this.runAfter.clear();}
            if (runAfter != null) {for (String item :runAfter){ this.addToRunAfter(item);}} return (A) this;
    }

    public Boolean hasRunAfter(){
            return runAfter != null && !runAfter.isEmpty();
    }

    public A addNewRunAfter(String arg1){
            return (A)addToRunAfter(new String(arg1));
    }

    public A addNewRunAfter(StringBuilder arg1){
            return (A)addToRunAfter(new String(arg1));
    }

    public A addNewRunAfter(StringBuffer arg1){
            return (A)addToRunAfter(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildTaskRef instead.
 * @return The buildable object.
 */
@Deprecated public TaskRef getTaskRef(){
            return this.taskRef!=null?this.taskRef.build():null;
    }

    public TaskRef buildTaskRef(){
            return this.taskRef!=null?this.taskRef.build():null;
    }

    public A withTaskRef(TaskRef taskRef){
            _visitables.get("taskRef").remove(this.taskRef);
            if (taskRef!=null){ this.taskRef= new TaskRefBuilder(taskRef); _visitables.get("taskRef").add(this.taskRef);} return (A) this;
    }

    public Boolean hasTaskRef(){
            return this.taskRef != null;
    }

    public A withNewTaskRef(String apiVersion,String kind,String name){
            return (A)withTaskRef(new TaskRef(apiVersion, kind, name));
    }

    public PipelineTaskFluent.TaskRefNested<A> withNewTaskRef(){
            return new TaskRefNestedImpl();
    }

    public PipelineTaskFluent.TaskRefNested<A> withNewTaskRefLike(TaskRef item){
            return new TaskRefNestedImpl(item);
    }

    public PipelineTaskFluent.TaskRefNested<A> editTaskRef(){
            return withNewTaskRefLike(getTaskRef());
    }

    public PipelineTaskFluent.TaskRefNested<A> editOrNewTaskRef(){
            return withNewTaskRefLike(getTaskRef() != null ? getTaskRef(): new TaskRefBuilder().build());
    }

    public PipelineTaskFluent.TaskRefNested<A> editOrNewTaskRefLike(TaskRef item){
            return withNewTaskRefLike(getTaskRef() != null ? getTaskRef(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PipelineTaskFluentImpl that = (PipelineTaskFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (params != null ? !params.equals(that.params) :that.params != null) return false;
            if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
            if (retries != null ? !retries.equals(that.retries) :that.retries != null) return false;
            if (runAfter != null ? !runAfter.equals(that.runAfter) :that.runAfter != null) return false;
            if (taskRef != null ? !taskRef.equals(that.taskRef) :that.taskRef != null) return false;
            return true;
    }


    public class ParamsNestedImpl<N> extends ParamFluentImpl<PipelineTaskFluent.ParamsNested<N>> implements PipelineTaskFluent.ParamsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ParamBuilder builder;
        private final int index;
    
            ParamsNestedImpl(int index,Param item){
                    this.index = index;
                    this.builder = new ParamBuilder(this, item);
            }
            ParamsNestedImpl(){
                    this.index = -1;
                    this.builder = new ParamBuilder(this);
            }
    
    public N and(){
            return (N) PipelineTaskFluentImpl.this.setToParams(index, builder.build());
    }
    public N endParam(){
            return and();
    }

}
    public class ResourcesNestedImpl<N> extends PipelineTaskResourcesFluentImpl<PipelineTaskFluent.ResourcesNested<N>> implements PipelineTaskFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PipelineTaskResourcesBuilder builder;
    
            ResourcesNestedImpl(PipelineTaskResources item){
                    this.builder = new PipelineTaskResourcesBuilder(this, item);
            }
            ResourcesNestedImpl(){
                    this.builder = new PipelineTaskResourcesBuilder(this);
            }
    
    public N and(){
            return (N) PipelineTaskFluentImpl.this.withResources(builder.build());
    }
    public N endResources(){
            return and();
    }

}
    public class TaskRefNestedImpl<N> extends TaskRefFluentImpl<PipelineTaskFluent.TaskRefNested<N>> implements PipelineTaskFluent.TaskRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TaskRefBuilder builder;
    
            TaskRefNestedImpl(TaskRef item){
                    this.builder = new TaskRefBuilder(this, item);
            }
            TaskRefNestedImpl(){
                    this.builder = new TaskRefBuilder(this);
            }
    
    public N and(){
            return (N) PipelineTaskFluentImpl.this.withTaskRef(builder.build());
    }
    public N endTaskRef(){
            return and();
    }

}


}
