package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class PipelineTaskInputResourceBuilder extends PipelineTaskInputResourceFluentImpl<PipelineTaskInputResourceBuilder> implements VisitableBuilder<PipelineTaskInputResource,PipelineTaskInputResourceBuilder>{

    PipelineTaskInputResourceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PipelineTaskInputResourceBuilder(){
            this(true);
    }
    public PipelineTaskInputResourceBuilder(Boolean validationEnabled){
            this(new PipelineTaskInputResource(), validationEnabled);
    }
    public PipelineTaskInputResourceBuilder(PipelineTaskInputResourceFluent<?> fluent){
            this(fluent, true);
    }
    public PipelineTaskInputResourceBuilder(PipelineTaskInputResourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PipelineTaskInputResource(), validationEnabled);
    }
    public PipelineTaskInputResourceBuilder(PipelineTaskInputResourceFluent<?> fluent,PipelineTaskInputResource instance){
            this(fluent, instance, true);
    }
    public PipelineTaskInputResourceBuilder(PipelineTaskInputResourceFluent<?> fluent,PipelineTaskInputResource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withFrom(instance.getFrom()); 
            fluent.withName(instance.getName()); 
            fluent.withResource(instance.getResource()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineTaskInputResourceBuilder(PipelineTaskInputResource instance){
            this(instance,true);
    }
    public PipelineTaskInputResourceBuilder(PipelineTaskInputResource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withFrom(instance.getFrom()); 
            this.withName(instance.getName()); 
            this.withResource(instance.getResource()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineTaskInputResourceBuilder(Validator validator){
            this(new PipelineTaskInputResource(), true);
    }
    public PipelineTaskInputResourceBuilder(PipelineTaskInputResourceFluent<?> fluent,PipelineTaskInputResource instance,Validator validator){
            this.fluent = fluent; 
            fluent.withFrom(instance.getFrom()); 
            fluent.withName(instance.getName()); 
            fluent.withResource(instance.getResource()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public PipelineTaskInputResourceBuilder(PipelineTaskInputResource instance,Validator validator){
            this.fluent = this; 
            this.withFrom(instance.getFrom()); 
            this.withName(instance.getName()); 
            this.withResource(instance.getResource()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public PipelineTaskInputResource build(){
            PipelineTaskInputResource buildable = new PipelineTaskInputResource(fluent.getFrom(),fluent.getName(),fluent.getResource());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PipelineTaskInputResourceBuilder that = (PipelineTaskInputResourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
