package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class PipelineTaskInputResourceFluentImpl<A extends PipelineTaskInputResourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PipelineTaskInputResourceFluent<A>{

    private List<String> from;
    private String name;
    private String resource;

    public PipelineTaskInputResourceFluentImpl(){
    }
    public PipelineTaskInputResourceFluentImpl(PipelineTaskInputResource instance){
            this.withFrom(instance.getFrom()); 
            this.withName(instance.getName()); 
            this.withResource(instance.getResource()); 
    }

    public A addToFrom(int index,String item){
            if (this.from == null) {this.from = new ArrayList<String>();}
            this.from.add(index, item);
            return (A)this;
    }

    public A setToFrom(int index,String item){
            if (this.from == null) {this.from = new ArrayList<String>();}
            this.from.set(index, item); return (A)this;
    }

    public A addToFrom(String... items){
            if (this.from == null) {this.from = new ArrayList<String>();}
            for (String item : items) {this.from.add(item);} return (A)this;
    }

    public A addAllToFrom(Collection<String> items){
            if (this.from == null) {this.from = new ArrayList<String>();}
            for (String item : items) {this.from.add(item);} return (A)this;
    }

    public A removeFromFrom(String... items){
            for (String item : items) {if (this.from!= null){ this.from.remove(item);}} return (A)this;
    }

    public A removeAllFromFrom(Collection<String> items){
            for (String item : items) {if (this.from!= null){ this.from.remove(item);}} return (A)this;
    }

    public List<String> getFrom(){
            return this.from;
    }

    public String getFrom(int index){
            return this.from.get(index);
    }

    public String getFirstFrom(){
            return this.from.get(0);
    }

    public String getLastFrom(){
            return this.from.get(from.size() - 1);
    }

    public String getMatchingFrom(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: from) { if(predicate.apply(item)){return item;} } return null;
    }

    public Boolean hasMatchingFrom(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: from) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withFrom(List<String> from){
            if (this.from != null) { _visitables.get("from").removeAll(this.from);}
            if (from != null) {this.from = new ArrayList<String>(); for (String item : from){this.addToFrom(item);}} else { this.from = new ArrayList<String>();} return (A) this;
    }

    public A withFrom(String... from){
            if (this.from != null) {this.from.clear();}
            if (from != null) {for (String item :from){ this.addToFrom(item);}} return (A) this;
    }

    public Boolean hasFrom(){
            return from != null && !from.isEmpty();
    }

    public A addNewFrom(String arg1){
            return (A)addToFrom(new String(arg1));
    }

    public A addNewFrom(StringBuilder arg1){
            return (A)addToFrom(new String(arg1));
    }

    public A addNewFrom(StringBuffer arg1){
            return (A)addToFrom(new String(arg1));
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public String getResource(){
            return this.resource;
    }

    public A withResource(String resource){
            this.resource=resource; return (A) this;
    }

    public Boolean hasResource(){
            return this.resource != null;
    }

    public A withNewResource(String arg1){
            return (A)withResource(new String(arg1));
    }

    public A withNewResource(StringBuilder arg1){
            return (A)withResource(new String(arg1));
    }

    public A withNewResource(StringBuffer arg1){
            return (A)withResource(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PipelineTaskInputResourceFluentImpl that = (PipelineTaskInputResourceFluentImpl) o;
            if (from != null ? !from.equals(that.from) :that.from != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (resource != null ? !resource.equals(that.resource) :that.resource != null) return false;
            return true;
    }




}
