package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class PipelineTaskOutputResourceBuilder extends PipelineTaskOutputResourceFluentImpl<PipelineTaskOutputResourceBuilder> implements VisitableBuilder<PipelineTaskOutputResource,PipelineTaskOutputResourceBuilder>{

    PipelineTaskOutputResourceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PipelineTaskOutputResourceBuilder(){
            this(true);
    }
    public PipelineTaskOutputResourceBuilder(Boolean validationEnabled){
            this(new PipelineTaskOutputResource(), validationEnabled);
    }
    public PipelineTaskOutputResourceBuilder(PipelineTaskOutputResourceFluent<?> fluent){
            this(fluent, true);
    }
    public PipelineTaskOutputResourceBuilder(PipelineTaskOutputResourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PipelineTaskOutputResource(), validationEnabled);
    }
    public PipelineTaskOutputResourceBuilder(PipelineTaskOutputResourceFluent<?> fluent,PipelineTaskOutputResource instance){
            this(fluent, instance, true);
    }
    public PipelineTaskOutputResourceBuilder(PipelineTaskOutputResourceFluent<?> fluent,PipelineTaskOutputResource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withResource(instance.getResource()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineTaskOutputResourceBuilder(PipelineTaskOutputResource instance){
            this(instance,true);
    }
    public PipelineTaskOutputResourceBuilder(PipelineTaskOutputResource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withResource(instance.getResource()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineTaskOutputResourceBuilder(Validator validator){
            this(new PipelineTaskOutputResource(), true);
    }
    public PipelineTaskOutputResourceBuilder(PipelineTaskOutputResourceFluent<?> fluent,PipelineTaskOutputResource instance,Validator validator){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withResource(instance.getResource()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public PipelineTaskOutputResourceBuilder(PipelineTaskOutputResource instance,Validator validator){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withResource(instance.getResource()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public PipelineTaskOutputResource build(){
            PipelineTaskOutputResource buildable = new PipelineTaskOutputResource(fluent.getName(),fluent.getResource());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PipelineTaskOutputResourceBuilder that = (PipelineTaskOutputResourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
