package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class PipelineTaskResourcesBuilder extends PipelineTaskResourcesFluentImpl<PipelineTaskResourcesBuilder> implements VisitableBuilder<PipelineTaskResources,PipelineTaskResourcesBuilder>{

    PipelineTaskResourcesFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PipelineTaskResourcesBuilder(){
            this(true);
    }
    public PipelineTaskResourcesBuilder(Boolean validationEnabled){
            this(new PipelineTaskResources(), validationEnabled);
    }
    public PipelineTaskResourcesBuilder(PipelineTaskResourcesFluent<?> fluent){
            this(fluent, true);
    }
    public PipelineTaskResourcesBuilder(PipelineTaskResourcesFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PipelineTaskResources(), validationEnabled);
    }
    public PipelineTaskResourcesBuilder(PipelineTaskResourcesFluent<?> fluent,PipelineTaskResources instance){
            this(fluent, instance, true);
    }
    public PipelineTaskResourcesBuilder(PipelineTaskResourcesFluent<?> fluent,PipelineTaskResources instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withInputs(instance.getInputs()); 
            fluent.withOutputs(instance.getOutputs()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineTaskResourcesBuilder(PipelineTaskResources instance){
            this(instance,true);
    }
    public PipelineTaskResourcesBuilder(PipelineTaskResources instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withInputs(instance.getInputs()); 
            this.withOutputs(instance.getOutputs()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineTaskResourcesBuilder(Validator validator){
            this(new PipelineTaskResources(), true);
    }
    public PipelineTaskResourcesBuilder(PipelineTaskResourcesFluent<?> fluent,PipelineTaskResources instance,Validator validator){
            this.fluent = fluent; 
            fluent.withInputs(instance.getInputs()); 
            fluent.withOutputs(instance.getOutputs()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public PipelineTaskResourcesBuilder(PipelineTaskResources instance,Validator validator){
            this.fluent = this; 
            this.withInputs(instance.getInputs()); 
            this.withOutputs(instance.getOutputs()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public PipelineTaskResources build(){
            PipelineTaskResources buildable = new PipelineTaskResources(fluent.getInputs(),fluent.getOutputs());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PipelineTaskResourcesBuilder that = (PipelineTaskResourcesBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
