package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;

public class PipelineTaskResourcesFluentImpl<A extends PipelineTaskResourcesFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PipelineTaskResourcesFluent<A>{

    private List<PipelineTaskInputResourceBuilder> inputs;
    private List<PipelineTaskOutputResourceBuilder> outputs;

    public PipelineTaskResourcesFluentImpl(){
    }
    public PipelineTaskResourcesFluentImpl(PipelineTaskResources instance){
            this.withInputs(instance.getInputs()); 
            this.withOutputs(instance.getOutputs()); 
    }

    public A addToInputs(int index,PipelineTaskInputResource item){
            if (this.inputs == null) {this.inputs = new ArrayList<PipelineTaskInputResourceBuilder>();}
            PipelineTaskInputResourceBuilder builder = new PipelineTaskInputResourceBuilder(item);_visitables.get("inputs").add(index >= 0 ? index : _visitables.get("inputs").size(), builder);this.inputs.add(index >= 0 ? index : inputs.size(), builder); return (A)this;
    }

    public A setToInputs(int index,PipelineTaskInputResource item){
            if (this.inputs == null) {this.inputs = new ArrayList<PipelineTaskInputResourceBuilder>();}
            PipelineTaskInputResourceBuilder builder = new PipelineTaskInputResourceBuilder(item);
            if (index < 0 || index >= _visitables.get("inputs").size()) { _visitables.get("inputs").add(builder); } else { _visitables.get("inputs").set(index, builder);}
            if (index < 0 || index >= inputs.size()) { inputs.add(builder); } else { inputs.set(index, builder);}
             return (A)this;
    }

    public A addToInputs(PipelineTaskInputResource... items){
            if (this.inputs == null) {this.inputs = new ArrayList<PipelineTaskInputResourceBuilder>();}
            for (PipelineTaskInputResource item : items) {PipelineTaskInputResourceBuilder builder = new PipelineTaskInputResourceBuilder(item);_visitables.get("inputs").add(builder);this.inputs.add(builder);} return (A)this;
    }

    public A addAllToInputs(Collection<PipelineTaskInputResource> items){
            if (this.inputs == null) {this.inputs = new ArrayList<PipelineTaskInputResourceBuilder>();}
            for (PipelineTaskInputResource item : items) {PipelineTaskInputResourceBuilder builder = new PipelineTaskInputResourceBuilder(item);_visitables.get("inputs").add(builder);this.inputs.add(builder);} return (A)this;
    }

    public A removeFromInputs(PipelineTaskInputResource... items){
            for (PipelineTaskInputResource item : items) {PipelineTaskInputResourceBuilder builder = new PipelineTaskInputResourceBuilder(item);_visitables.get("inputs").remove(builder);if (this.inputs != null) {this.inputs.remove(builder);}} return (A)this;
    }

    public A removeAllFromInputs(Collection<PipelineTaskInputResource> items){
            for (PipelineTaskInputResource item : items) {PipelineTaskInputResourceBuilder builder = new PipelineTaskInputResourceBuilder(item);_visitables.get("inputs").remove(builder);if (this.inputs != null) {this.inputs.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildInputs instead.
 * @return The buildable object.
 */
@Deprecated public List<PipelineTaskInputResource> getInputs(){
            return build(inputs);
    }

    public List<PipelineTaskInputResource> buildInputs(){
            return build(inputs);
    }

    public PipelineTaskInputResource buildInput(int index){
            return this.inputs.get(index).build();
    }

    public PipelineTaskInputResource buildFirstInput(){
            return this.inputs.get(0).build();
    }

    public PipelineTaskInputResource buildLastInput(){
            return this.inputs.get(inputs.size() - 1).build();
    }

    public PipelineTaskInputResource buildMatchingInput(io.fabric8.kubernetes.api.builder.Predicate<PipelineTaskInputResourceBuilder> predicate){
            for (PipelineTaskInputResourceBuilder item: inputs) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingInput(io.fabric8.kubernetes.api.builder.Predicate<PipelineTaskInputResourceBuilder> predicate){
            for (PipelineTaskInputResourceBuilder item: inputs) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withInputs(List<PipelineTaskInputResource> inputs){
            if (this.inputs != null) { _visitables.get("inputs").removeAll(this.inputs);}
            if (inputs != null) {this.inputs = new ArrayList<PipelineTaskInputResourceBuilder>(); for (PipelineTaskInputResource item : inputs){this.addToInputs(item);}} else { this.inputs = new ArrayList<PipelineTaskInputResourceBuilder>();} return (A) this;
    }

    public A withInputs(PipelineTaskInputResource... inputs){
            if (this.inputs != null) {this.inputs.clear();}
            if (inputs != null) {for (PipelineTaskInputResource item :inputs){ this.addToInputs(item);}} return (A) this;
    }

    public Boolean hasInputs(){
            return inputs != null && !inputs.isEmpty();
    }

    public PipelineTaskResourcesFluent.InputsNested<A> addNewInput(){
            return new InputsNestedImpl();
    }

    public PipelineTaskResourcesFluent.InputsNested<A> addNewInputLike(PipelineTaskInputResource item){
            return new InputsNestedImpl(-1, item);
    }

    public PipelineTaskResourcesFluent.InputsNested<A> setNewInputLike(int index,PipelineTaskInputResource item){
            return new InputsNestedImpl(index, item);
    }

    public PipelineTaskResourcesFluent.InputsNested<A> editInput(int index){
            if (inputs.size() <= index) throw new RuntimeException("Can't edit inputs. Index exceeds size.");
            return setNewInputLike(index, buildInput(index));
    }

    public PipelineTaskResourcesFluent.InputsNested<A> editFirstInput(){
            if (inputs.size() == 0) throw new RuntimeException("Can't edit first inputs. The list is empty.");
            return setNewInputLike(0, buildInput(0));
    }

    public PipelineTaskResourcesFluent.InputsNested<A> editLastInput(){
            int index = inputs.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last inputs. The list is empty.");
            return setNewInputLike(index, buildInput(index));
    }

    public PipelineTaskResourcesFluent.InputsNested<A> editMatchingInput(io.fabric8.kubernetes.api.builder.Predicate<PipelineTaskInputResourceBuilder> predicate){
            int index = -1;
            for (int i=0;i<inputs.size();i++) { 
            if (predicate.apply(inputs.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching inputs. No match found.");
            return setNewInputLike(index, buildInput(index));
    }

    public A addToOutputs(int index,PipelineTaskOutputResource item){
            if (this.outputs == null) {this.outputs = new ArrayList<PipelineTaskOutputResourceBuilder>();}
            PipelineTaskOutputResourceBuilder builder = new PipelineTaskOutputResourceBuilder(item);_visitables.get("outputs").add(index >= 0 ? index : _visitables.get("outputs").size(), builder);this.outputs.add(index >= 0 ? index : outputs.size(), builder); return (A)this;
    }

    public A setToOutputs(int index,PipelineTaskOutputResource item){
            if (this.outputs == null) {this.outputs = new ArrayList<PipelineTaskOutputResourceBuilder>();}
            PipelineTaskOutputResourceBuilder builder = new PipelineTaskOutputResourceBuilder(item);
            if (index < 0 || index >= _visitables.get("outputs").size()) { _visitables.get("outputs").add(builder); } else { _visitables.get("outputs").set(index, builder);}
            if (index < 0 || index >= outputs.size()) { outputs.add(builder); } else { outputs.set(index, builder);}
             return (A)this;
    }

    public A addToOutputs(PipelineTaskOutputResource... items){
            if (this.outputs == null) {this.outputs = new ArrayList<PipelineTaskOutputResourceBuilder>();}
            for (PipelineTaskOutputResource item : items) {PipelineTaskOutputResourceBuilder builder = new PipelineTaskOutputResourceBuilder(item);_visitables.get("outputs").add(builder);this.outputs.add(builder);} return (A)this;
    }

    public A addAllToOutputs(Collection<PipelineTaskOutputResource> items){
            if (this.outputs == null) {this.outputs = new ArrayList<PipelineTaskOutputResourceBuilder>();}
            for (PipelineTaskOutputResource item : items) {PipelineTaskOutputResourceBuilder builder = new PipelineTaskOutputResourceBuilder(item);_visitables.get("outputs").add(builder);this.outputs.add(builder);} return (A)this;
    }

    public A removeFromOutputs(PipelineTaskOutputResource... items){
            for (PipelineTaskOutputResource item : items) {PipelineTaskOutputResourceBuilder builder = new PipelineTaskOutputResourceBuilder(item);_visitables.get("outputs").remove(builder);if (this.outputs != null) {this.outputs.remove(builder);}} return (A)this;
    }

    public A removeAllFromOutputs(Collection<PipelineTaskOutputResource> items){
            for (PipelineTaskOutputResource item : items) {PipelineTaskOutputResourceBuilder builder = new PipelineTaskOutputResourceBuilder(item);_visitables.get("outputs").remove(builder);if (this.outputs != null) {this.outputs.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildOutputs instead.
 * @return The buildable object.
 */
@Deprecated public List<PipelineTaskOutputResource> getOutputs(){
            return build(outputs);
    }

    public List<PipelineTaskOutputResource> buildOutputs(){
            return build(outputs);
    }

    public PipelineTaskOutputResource buildOutput(int index){
            return this.outputs.get(index).build();
    }

    public PipelineTaskOutputResource buildFirstOutput(){
            return this.outputs.get(0).build();
    }

    public PipelineTaskOutputResource buildLastOutput(){
            return this.outputs.get(outputs.size() - 1).build();
    }

    public PipelineTaskOutputResource buildMatchingOutput(io.fabric8.kubernetes.api.builder.Predicate<PipelineTaskOutputResourceBuilder> predicate){
            for (PipelineTaskOutputResourceBuilder item: outputs) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingOutput(io.fabric8.kubernetes.api.builder.Predicate<PipelineTaskOutputResourceBuilder> predicate){
            for (PipelineTaskOutputResourceBuilder item: outputs) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withOutputs(List<PipelineTaskOutputResource> outputs){
            if (this.outputs != null) { _visitables.get("outputs").removeAll(this.outputs);}
            if (outputs != null) {this.outputs = new ArrayList<PipelineTaskOutputResourceBuilder>(); for (PipelineTaskOutputResource item : outputs){this.addToOutputs(item);}} else { this.outputs = new ArrayList<PipelineTaskOutputResourceBuilder>();} return (A) this;
    }

    public A withOutputs(PipelineTaskOutputResource... outputs){
            if (this.outputs != null) {this.outputs.clear();}
            if (outputs != null) {for (PipelineTaskOutputResource item :outputs){ this.addToOutputs(item);}} return (A) this;
    }

    public Boolean hasOutputs(){
            return outputs != null && !outputs.isEmpty();
    }

    public A addNewOutput(String name,String resource){
            return (A)addToOutputs(new PipelineTaskOutputResource(name, resource));
    }

    public PipelineTaskResourcesFluent.OutputsNested<A> addNewOutput(){
            return new OutputsNestedImpl();
    }

    public PipelineTaskResourcesFluent.OutputsNested<A> addNewOutputLike(PipelineTaskOutputResource item){
            return new OutputsNestedImpl(-1, item);
    }

    public PipelineTaskResourcesFluent.OutputsNested<A> setNewOutputLike(int index,PipelineTaskOutputResource item){
            return new OutputsNestedImpl(index, item);
    }

    public PipelineTaskResourcesFluent.OutputsNested<A> editOutput(int index){
            if (outputs.size() <= index) throw new RuntimeException("Can't edit outputs. Index exceeds size.");
            return setNewOutputLike(index, buildOutput(index));
    }

    public PipelineTaskResourcesFluent.OutputsNested<A> editFirstOutput(){
            if (outputs.size() == 0) throw new RuntimeException("Can't edit first outputs. The list is empty.");
            return setNewOutputLike(0, buildOutput(0));
    }

    public PipelineTaskResourcesFluent.OutputsNested<A> editLastOutput(){
            int index = outputs.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last outputs. The list is empty.");
            return setNewOutputLike(index, buildOutput(index));
    }

    public PipelineTaskResourcesFluent.OutputsNested<A> editMatchingOutput(io.fabric8.kubernetes.api.builder.Predicate<PipelineTaskOutputResourceBuilder> predicate){
            int index = -1;
            for (int i=0;i<outputs.size();i++) { 
            if (predicate.apply(outputs.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching outputs. No match found.");
            return setNewOutputLike(index, buildOutput(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PipelineTaskResourcesFluentImpl that = (PipelineTaskResourcesFluentImpl) o;
            if (inputs != null ? !inputs.equals(that.inputs) :that.inputs != null) return false;
            if (outputs != null ? !outputs.equals(that.outputs) :that.outputs != null) return false;
            return true;
    }


    public class InputsNestedImpl<N> extends PipelineTaskInputResourceFluentImpl<PipelineTaskResourcesFluent.InputsNested<N>> implements PipelineTaskResourcesFluent.InputsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PipelineTaskInputResourceBuilder builder;
        private final int index;
    
            InputsNestedImpl(int index,PipelineTaskInputResource item){
                    this.index = index;
                    this.builder = new PipelineTaskInputResourceBuilder(this, item);
            }
            InputsNestedImpl(){
                    this.index = -1;
                    this.builder = new PipelineTaskInputResourceBuilder(this);
            }
    
    public N and(){
            return (N) PipelineTaskResourcesFluentImpl.this.setToInputs(index, builder.build());
    }
    public N endInput(){
            return and();
    }

}
    public class OutputsNestedImpl<N> extends PipelineTaskOutputResourceFluentImpl<PipelineTaskResourcesFluent.OutputsNested<N>> implements PipelineTaskResourcesFluent.OutputsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PipelineTaskOutputResourceBuilder builder;
        private final int index;
    
            OutputsNestedImpl(int index,PipelineTaskOutputResource item){
                    this.index = index;
                    this.builder = new PipelineTaskOutputResourceBuilder(this, item);
            }
            OutputsNestedImpl(){
                    this.index = -1;
                    this.builder = new PipelineTaskOutputResourceBuilder(this);
            }
    
    public N and(){
            return (N) PipelineTaskResourcesFluentImpl.this.setToOutputs(index, builder.build());
    }
    public N endOutput(){
            return and();
    }

}


}
