package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ResultsBuilder extends ResultsFluentImpl<ResultsBuilder> implements VisitableBuilder<Results,ResultsBuilder>{

    ResultsFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ResultsBuilder(){
            this(true);
    }
    public ResultsBuilder(Boolean validationEnabled){
            this(new Results(), validationEnabled);
    }
    public ResultsBuilder(ResultsFluent<?> fluent){
            this(fluent, true);
    }
    public ResultsBuilder(ResultsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Results(), validationEnabled);
    }
    public ResultsBuilder(ResultsFluent<?> fluent,Results instance){
            this(fluent, instance, true);
    }
    public ResultsBuilder(ResultsFluent<?> fluent,Results instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withType(instance.getType()); 
            fluent.withUrl(instance.getUrl()); 
            this.validationEnabled = validationEnabled; 
    }
    public ResultsBuilder(Results instance){
            this(instance,true);
    }
    public ResultsBuilder(Results instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withType(instance.getType()); 
            this.withUrl(instance.getUrl()); 
            this.validationEnabled = validationEnabled; 
    }
    public ResultsBuilder(Validator validator){
            this(new Results(), true);
    }
    public ResultsBuilder(ResultsFluent<?> fluent,Results instance,Validator validator){
            this.fluent = fluent; 
            fluent.withType(instance.getType()); 
            fluent.withUrl(instance.getUrl()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ResultsBuilder(Results instance,Validator validator){
            this.fluent = this; 
            this.withType(instance.getType()); 
            this.withUrl(instance.getUrl()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Results build(){
            Results buildable = new Results(fluent.getType(),fluent.getUrl());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ResultsBuilder that = (ResultsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
