package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class SecretParamBuilder extends SecretParamFluentImpl<SecretParamBuilder> implements VisitableBuilder<SecretParam,SecretParamBuilder>{

    SecretParamFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public SecretParamBuilder(){
            this(true);
    }
    public SecretParamBuilder(Boolean validationEnabled){
            this(new SecretParam(), validationEnabled);
    }
    public SecretParamBuilder(SecretParamFluent<?> fluent){
            this(fluent, true);
    }
    public SecretParamBuilder(SecretParamFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SecretParam(), validationEnabled);
    }
    public SecretParamBuilder(SecretParamFluent<?> fluent,SecretParam instance){
            this(fluent, instance, true);
    }
    public SecretParamBuilder(SecretParamFluent<?> fluent,SecretParam instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withFieldName(instance.getFieldName()); 
            fluent.withSecretKey(instance.getSecretKey()); 
            fluent.withSecretName(instance.getSecretName()); 
            this.validationEnabled = validationEnabled; 
    }
    public SecretParamBuilder(SecretParam instance){
            this(instance,true);
    }
    public SecretParamBuilder(SecretParam instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withFieldName(instance.getFieldName()); 
            this.withSecretKey(instance.getSecretKey()); 
            this.withSecretName(instance.getSecretName()); 
            this.validationEnabled = validationEnabled; 
    }
    public SecretParamBuilder(Validator validator){
            this(new SecretParam(), true);
    }
    public SecretParamBuilder(SecretParamFluent<?> fluent,SecretParam instance,Validator validator){
            this.fluent = fluent; 
            fluent.withFieldName(instance.getFieldName()); 
            fluent.withSecretKey(instance.getSecretKey()); 
            fluent.withSecretName(instance.getSecretName()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public SecretParamBuilder(SecretParam instance,Validator validator){
            this.fluent = this; 
            this.withFieldName(instance.getFieldName()); 
            this.withSecretKey(instance.getSecretKey()); 
            this.withSecretName(instance.getSecretName()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public SecretParam build(){
            SecretParam buildable = new SecretParam(fluent.getFieldName(),fluent.getSecretKey(),fluent.getSecretName());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SecretParamBuilder that = (SecretParamBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
