package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class TaskListBuilder extends TaskListFluentImpl<TaskListBuilder> implements VisitableBuilder<TaskList,TaskListBuilder>{

    TaskListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TaskListBuilder(){
            this(true);
    }
    public TaskListBuilder(Boolean validationEnabled){
            this(new TaskList(), validationEnabled);
    }
    public TaskListBuilder(TaskListFluent<?> fluent){
            this(fluent, true);
    }
    public TaskListBuilder(TaskListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TaskList(), validationEnabled);
    }
    public TaskListBuilder(TaskListFluent<?> fluent,TaskList instance){
            this(fluent, instance, true);
    }
    public TaskListBuilder(TaskListFluent<?> fluent,TaskList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public TaskListBuilder(TaskList instance){
            this(instance,true);
    }
    public TaskListBuilder(TaskList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public TaskListBuilder(Validator validator){
            this(new TaskList(), true);
    }
    public TaskListBuilder(TaskListFluent<?> fluent,TaskList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public TaskListBuilder(TaskList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public TaskList build(){
            TaskList buildable = new TaskList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TaskListBuilder that = (TaskListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
