package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface TaskListFluent<A extends TaskListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Task item);
    public A setToItems(int index,Task item);
    public A addToItems(Task... items);
    public A addAllToItems(Collection<Task> items);
    public A removeFromItems(Task... items);
    public A removeAllFromItems(Collection<Task> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Task> getItems();
    public List<Task> buildItems();
    public Task buildItem(int index);
    public Task buildFirstItem();
    public Task buildLastItem();
    public Task buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<TaskBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<TaskBuilder> predicate);
    public A withItems(List<Task> items);
    public A withItems(Task... items);
    public Boolean hasItems();
    public TaskListFluent.ItemsNested<A> addNewItem();
    public TaskListFluent.ItemsNested<A> addNewItemLike(Task item);
    public TaskListFluent.ItemsNested<A> setNewItemLike(int index,Task item);
    public TaskListFluent.ItemsNested<A> editItem(int index);
    public TaskListFluent.ItemsNested<A> editFirstItem();
    public TaskListFluent.ItemsNested<A> editLastItem();
    public TaskListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<TaskBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TaskFluent<TaskListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
