package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class TaskRefBuilder extends TaskRefFluentImpl<TaskRefBuilder> implements VisitableBuilder<TaskRef,TaskRefBuilder>{

    TaskRefFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TaskRefBuilder(){
            this(true);
    }
    public TaskRefBuilder(Boolean validationEnabled){
            this(new TaskRef(), validationEnabled);
    }
    public TaskRefBuilder(TaskRefFluent<?> fluent){
            this(fluent, true);
    }
    public TaskRefBuilder(TaskRefFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TaskRef(), validationEnabled);
    }
    public TaskRefBuilder(TaskRefFluent<?> fluent,TaskRef instance){
            this(fluent, instance, true);
    }
    public TaskRefBuilder(TaskRefFluent<?> fluent,TaskRef instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public TaskRefBuilder(TaskRef instance){
            this(instance,true);
    }
    public TaskRefBuilder(TaskRef instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public TaskRefBuilder(Validator validator){
            this(new TaskRef(), true);
    }
    public TaskRefBuilder(TaskRefFluent<?> fluent,TaskRef instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withName(instance.getName()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public TaskRefBuilder(TaskRef instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withName(instance.getName()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public TaskRef build(){
            TaskRef buildable = new TaskRef(fluent.getApiVersion(),fluent.getKind(),fluent.getName());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TaskRefBuilder that = (TaskRefBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
