package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface TaskResourceBindingFluent<A extends TaskResourceBindingFluent<A>> extends Fluent<A>{


    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    public A addToPaths(int index,String item);
    public A setToPaths(int index,String item);
    public A addToPaths(String... items);
    public A addAllToPaths(Collection<String> items);
    public A removeFromPaths(String... items);
    public A removeAllFromPaths(Collection<String> items);
    public List<String> getPaths();
    public String getPath(int index);
    public String getFirstPath();
    public String getLastPath();
    public String getMatchingPath(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingPath(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withPaths(List<String> paths);
    public A withPaths(String... paths);
    public Boolean hasPaths();
    public A addNewPath(String arg1);
    public A addNewPath(StringBuilder arg1);
    public A addNewPath(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildResourceRef instead.
 * @return The buildable object.
 */
@Deprecated public PipelineResourceRef getResourceRef();
    public PipelineResourceRef buildResourceRef();
    public A withResourceRef(PipelineResourceRef resourceRef);
    public Boolean hasResourceRef();
    public A withNewResourceRef(String apiVersion,String name);
    public TaskResourceBindingFluent.ResourceRefNested<A> withNewResourceRef();
    public TaskResourceBindingFluent.ResourceRefNested<A> withNewResourceRefLike(PipelineResourceRef item);
    public TaskResourceBindingFluent.ResourceRefNested<A> editResourceRef();
    public TaskResourceBindingFluent.ResourceRefNested<A> editOrNewResourceRef();
    public TaskResourceBindingFluent.ResourceRefNested<A> editOrNewResourceRefLike(PipelineResourceRef item);
    
/**
 * This method has been deprecated, please use method buildResourceSpec instead.
 * @return The buildable object.
 */
@Deprecated public PipelineResourceSpec getResourceSpec();
    public PipelineResourceSpec buildResourceSpec();
    public A withResourceSpec(PipelineResourceSpec resourceSpec);
    public Boolean hasResourceSpec();
    public TaskResourceBindingFluent.ResourceSpecNested<A> withNewResourceSpec();
    public TaskResourceBindingFluent.ResourceSpecNested<A> withNewResourceSpecLike(PipelineResourceSpec item);
    public TaskResourceBindingFluent.ResourceSpecNested<A> editResourceSpec();
    public TaskResourceBindingFluent.ResourceSpecNested<A> editOrNewResourceSpec();
    public TaskResourceBindingFluent.ResourceSpecNested<A> editOrNewResourceSpecLike(PipelineResourceSpec item);

    public interface ResourceRefNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PipelineResourceRefFluent<TaskResourceBindingFluent.ResourceRefNested<N>>{

        
    public N and();    public N endResourceRef();
}
    public interface ResourceSpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PipelineResourceSpecFluent<TaskResourceBindingFluent.ResourceSpecNested<N>>{

        
    public N and();    public N endResourceSpec();
}


}
