package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class TaskResourceBuilder extends TaskResourceFluentImpl<TaskResourceBuilder> implements VisitableBuilder<TaskResource,TaskResourceBuilder>{

    TaskResourceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TaskResourceBuilder(){
            this(true);
    }
    public TaskResourceBuilder(Boolean validationEnabled){
            this(new TaskResource(), validationEnabled);
    }
    public TaskResourceBuilder(TaskResourceFluent<?> fluent){
            this(fluent, true);
    }
    public TaskResourceBuilder(TaskResourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TaskResource(), validationEnabled);
    }
    public TaskResourceBuilder(TaskResourceFluent<?> fluent,TaskResource instance){
            this(fluent, instance, true);
    }
    public TaskResourceBuilder(TaskResourceFluent<?> fluent,TaskResource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withOutputImageDir(instance.getOutputImageDir()); 
            fluent.withTargetPath(instance.getTargetPath()); 
            fluent.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }
    public TaskResourceBuilder(TaskResource instance){
            this(instance,true);
    }
    public TaskResourceBuilder(TaskResource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withOutputImageDir(instance.getOutputImageDir()); 
            this.withTargetPath(instance.getTargetPath()); 
            this.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }
    public TaskResourceBuilder(Validator validator){
            this(new TaskResource(), true);
    }
    public TaskResourceBuilder(TaskResourceFluent<?> fluent,TaskResource instance,Validator validator){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withOutputImageDir(instance.getOutputImageDir()); 
            fluent.withTargetPath(instance.getTargetPath()); 
            fluent.withType(instance.getType()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public TaskResourceBuilder(TaskResource instance,Validator validator){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withOutputImageDir(instance.getOutputImageDir()); 
            this.withTargetPath(instance.getTargetPath()); 
            this.withType(instance.getType()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public TaskResource build(){
            TaskResource buildable = new TaskResource(fluent.getName(),fluent.getOutputImageDir(),fluent.getTargetPath(),fluent.getType());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TaskResourceBuilder that = (TaskResourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
