package io.fabric8.tekton.pipeline.v1alpha1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class TaskResourceFluentImpl<A extends TaskResourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TaskResourceFluent<A>{

    private String name;
    private String outputImageDir;
    private String targetPath;
    private String type;

    public TaskResourceFluentImpl(){
    }
    public TaskResourceFluentImpl(TaskResource instance){
            this.withName(instance.getName()); 
            this.withOutputImageDir(instance.getOutputImageDir()); 
            this.withTargetPath(instance.getTargetPath()); 
            this.withType(instance.getType()); 
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public String getOutputImageDir(){
            return this.outputImageDir;
    }

    public A withOutputImageDir(String outputImageDir){
            this.outputImageDir=outputImageDir; return (A) this;
    }

    public Boolean hasOutputImageDir(){
            return this.outputImageDir != null;
    }

    public A withNewOutputImageDir(String arg1){
            return (A)withOutputImageDir(new String(arg1));
    }

    public A withNewOutputImageDir(StringBuilder arg1){
            return (A)withOutputImageDir(new String(arg1));
    }

    public A withNewOutputImageDir(StringBuffer arg1){
            return (A)withOutputImageDir(new String(arg1));
    }

    public String getTargetPath(){
            return this.targetPath;
    }

    public A withTargetPath(String targetPath){
            this.targetPath=targetPath; return (A) this;
    }

    public Boolean hasTargetPath(){
            return this.targetPath != null;
    }

    public A withNewTargetPath(String arg1){
            return (A)withTargetPath(new String(arg1));
    }

    public A withNewTargetPath(StringBuilder arg1){
            return (A)withTargetPath(new String(arg1));
    }

    public A withNewTargetPath(StringBuffer arg1){
            return (A)withTargetPath(new String(arg1));
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type != null;
    }

    public A withNewType(String arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuilder arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1){
            return (A)withType(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TaskResourceFluentImpl that = (TaskResourceFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (outputImageDir != null ? !outputImageDir.equals(that.outputImageDir) :that.outputImageDir != null) return false;
            if (targetPath != null ? !targetPath.equals(that.targetPath) :that.targetPath != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }




}
