package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;

public class TaskRunInputsFluentImpl<A extends TaskRunInputsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TaskRunInputsFluent<A>{

    private List<ParamBuilder> params;
    private List<TaskResourceBindingBuilder> resources;

    public TaskRunInputsFluentImpl(){
    }
    public TaskRunInputsFluentImpl(TaskRunInputs instance){
            this.withParams(instance.getParams()); 
            this.withResources(instance.getResources()); 
    }

    public A addToParams(int index,Param item){
            if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
            ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").add(index >= 0 ? index : _visitables.get("params").size(), builder);this.params.add(index >= 0 ? index : params.size(), builder); return (A)this;
    }

    public A setToParams(int index,Param item){
            if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
            ParamBuilder builder = new ParamBuilder(item);
            if (index < 0 || index >= _visitables.get("params").size()) { _visitables.get("params").add(builder); } else { _visitables.get("params").set(index, builder);}
            if (index < 0 || index >= params.size()) { params.add(builder); } else { params.set(index, builder);}
             return (A)this;
    }

    public A addToParams(Param... items){
            if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
            for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
    }

    public A addAllToParams(Collection<Param> items){
            if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
            for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
    }

    public A removeFromParams(Param... items){
            for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").remove(builder);if (this.params != null) {this.params.remove(builder);}} return (A)this;
    }

    public A removeAllFromParams(Collection<Param> items){
            for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").remove(builder);if (this.params != null) {this.params.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildParams instead.
 * @return The buildable object.
 */
@Deprecated public List<Param> getParams(){
            return build(params);
    }

    public List<Param> buildParams(){
            return build(params);
    }

    public Param buildParam(int index){
            return this.params.get(index).build();
    }

    public Param buildFirstParam(){
            return this.params.get(0).build();
    }

    public Param buildLastParam(){
            return this.params.get(params.size() - 1).build();
    }

    public Param buildMatchingParam(io.fabric8.kubernetes.api.builder.Predicate<ParamBuilder> predicate){
            for (ParamBuilder item: params) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingParam(io.fabric8.kubernetes.api.builder.Predicate<ParamBuilder> predicate){
            for (ParamBuilder item: params) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withParams(List<Param> params){
            if (this.params != null) { _visitables.get("params").removeAll(this.params);}
            if (params != null) {this.params = new ArrayList<ParamBuilder>(); for (Param item : params){this.addToParams(item);}} else { this.params = new ArrayList<ParamBuilder>();} return (A) this;
    }

    public A withParams(Param... params){
            if (this.params != null) {this.params.clear();}
            if (params != null) {for (Param item :params){ this.addToParams(item);}} return (A) this;
    }

    public Boolean hasParams(){
            return params != null && !params.isEmpty();
    }

    public A addNewParam(String name,String value){
            return (A)addToParams(new Param(name, value));
    }

    public TaskRunInputsFluent.ParamsNested<A> addNewParam(){
            return new ParamsNestedImpl();
    }

    public TaskRunInputsFluent.ParamsNested<A> addNewParamLike(Param item){
            return new ParamsNestedImpl(-1, item);
    }

    public TaskRunInputsFluent.ParamsNested<A> setNewParamLike(int index,Param item){
            return new ParamsNestedImpl(index, item);
    }

    public TaskRunInputsFluent.ParamsNested<A> editParam(int index){
            if (params.size() <= index) throw new RuntimeException("Can't edit params. Index exceeds size.");
            return setNewParamLike(index, buildParam(index));
    }

    public TaskRunInputsFluent.ParamsNested<A> editFirstParam(){
            if (params.size() == 0) throw new RuntimeException("Can't edit first params. The list is empty.");
            return setNewParamLike(0, buildParam(0));
    }

    public TaskRunInputsFluent.ParamsNested<A> editLastParam(){
            int index = params.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last params. The list is empty.");
            return setNewParamLike(index, buildParam(index));
    }

    public TaskRunInputsFluent.ParamsNested<A> editMatchingParam(io.fabric8.kubernetes.api.builder.Predicate<ParamBuilder> predicate){
            int index = -1;
            for (int i=0;i<params.size();i++) { 
            if (predicate.apply(params.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching params. No match found.");
            return setNewParamLike(index, buildParam(index));
    }

    public A addToResources(int index,TaskResourceBinding item){
            if (this.resources == null) {this.resources = new ArrayList<TaskResourceBindingBuilder>();}
            TaskResourceBindingBuilder builder = new TaskResourceBindingBuilder(item);_visitables.get("resources").add(index >= 0 ? index : _visitables.get("resources").size(), builder);this.resources.add(index >= 0 ? index : resources.size(), builder); return (A)this;
    }

    public A setToResources(int index,TaskResourceBinding item){
            if (this.resources == null) {this.resources = new ArrayList<TaskResourceBindingBuilder>();}
            TaskResourceBindingBuilder builder = new TaskResourceBindingBuilder(item);
            if (index < 0 || index >= _visitables.get("resources").size()) { _visitables.get("resources").add(builder); } else { _visitables.get("resources").set(index, builder);}
            if (index < 0 || index >= resources.size()) { resources.add(builder); } else { resources.set(index, builder);}
             return (A)this;
    }

    public A addToResources(TaskResourceBinding... items){
            if (this.resources == null) {this.resources = new ArrayList<TaskResourceBindingBuilder>();}
            for (TaskResourceBinding item : items) {TaskResourceBindingBuilder builder = new TaskResourceBindingBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
    }

    public A addAllToResources(Collection<TaskResourceBinding> items){
            if (this.resources == null) {this.resources = new ArrayList<TaskResourceBindingBuilder>();}
            for (TaskResourceBinding item : items) {TaskResourceBindingBuilder builder = new TaskResourceBindingBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
    }

    public A removeFromResources(TaskResourceBinding... items){
            for (TaskResourceBinding item : items) {TaskResourceBindingBuilder builder = new TaskResourceBindingBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
    }

    public A removeAllFromResources(Collection<TaskResourceBinding> items){
            for (TaskResourceBinding item : items) {TaskResourceBindingBuilder builder = new TaskResourceBindingBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public List<TaskResourceBinding> getResources(){
            return build(resources);
    }

    public List<TaskResourceBinding> buildResources(){
            return build(resources);
    }

    public TaskResourceBinding buildResource(int index){
            return this.resources.get(index).build();
    }

    public TaskResourceBinding buildFirstResource(){
            return this.resources.get(0).build();
    }

    public TaskResourceBinding buildLastResource(){
            return this.resources.get(resources.size() - 1).build();
    }

    public TaskResourceBinding buildMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<TaskResourceBindingBuilder> predicate){
            for (TaskResourceBindingBuilder item: resources) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<TaskResourceBindingBuilder> predicate){
            for (TaskResourceBindingBuilder item: resources) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withResources(List<TaskResourceBinding> resources){
            if (this.resources != null) { _visitables.get("resources").removeAll(this.resources);}
            if (resources != null) {this.resources = new ArrayList<TaskResourceBindingBuilder>(); for (TaskResourceBinding item : resources){this.addToResources(item);}} else { this.resources = new ArrayList<TaskResourceBindingBuilder>();} return (A) this;
    }

    public A withResources(TaskResourceBinding... resources){
            if (this.resources != null) {this.resources.clear();}
            if (resources != null) {for (TaskResourceBinding item :resources){ this.addToResources(item);}} return (A) this;
    }

    public Boolean hasResources(){
            return resources != null && !resources.isEmpty();
    }

    public TaskRunInputsFluent.ResourcesNested<A> addNewResource(){
            return new ResourcesNestedImpl();
    }

    public TaskRunInputsFluent.ResourcesNested<A> addNewResourceLike(TaskResourceBinding item){
            return new ResourcesNestedImpl(-1, item);
    }

    public TaskRunInputsFluent.ResourcesNested<A> setNewResourceLike(int index,TaskResourceBinding item){
            return new ResourcesNestedImpl(index, item);
    }

    public TaskRunInputsFluent.ResourcesNested<A> editResource(int index){
            if (resources.size() <= index) throw new RuntimeException("Can't edit resources. Index exceeds size.");
            return setNewResourceLike(index, buildResource(index));
    }

    public TaskRunInputsFluent.ResourcesNested<A> editFirstResource(){
            if (resources.size() == 0) throw new RuntimeException("Can't edit first resources. The list is empty.");
            return setNewResourceLike(0, buildResource(0));
    }

    public TaskRunInputsFluent.ResourcesNested<A> editLastResource(){
            int index = resources.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last resources. The list is empty.");
            return setNewResourceLike(index, buildResource(index));
    }

    public TaskRunInputsFluent.ResourcesNested<A> editMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<TaskResourceBindingBuilder> predicate){
            int index = -1;
            for (int i=0;i<resources.size();i++) { 
            if (predicate.apply(resources.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching resources. No match found.");
            return setNewResourceLike(index, buildResource(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TaskRunInputsFluentImpl that = (TaskRunInputsFluentImpl) o;
            if (params != null ? !params.equals(that.params) :that.params != null) return false;
            if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
            return true;
    }


    public class ParamsNestedImpl<N> extends ParamFluentImpl<TaskRunInputsFluent.ParamsNested<N>> implements TaskRunInputsFluent.ParamsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ParamBuilder builder;
        private final int index;
    
            ParamsNestedImpl(int index,Param item){
                    this.index = index;
                    this.builder = new ParamBuilder(this, item);
            }
            ParamsNestedImpl(){
                    this.index = -1;
                    this.builder = new ParamBuilder(this);
            }
    
    public N and(){
            return (N) TaskRunInputsFluentImpl.this.setToParams(index, builder.build());
    }
    public N endParam(){
            return and();
    }

}
    public class ResourcesNestedImpl<N> extends TaskResourceBindingFluentImpl<TaskRunInputsFluent.ResourcesNested<N>> implements TaskRunInputsFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TaskResourceBindingBuilder builder;
        private final int index;
    
            ResourcesNestedImpl(int index,TaskResourceBinding item){
                    this.index = index;
                    this.builder = new TaskResourceBindingBuilder(this, item);
            }
            ResourcesNestedImpl(){
                    this.index = -1;
                    this.builder = new TaskResourceBindingBuilder(this);
            }
    
    public N and(){
            return (N) TaskRunInputsFluentImpl.this.setToResources(index, builder.build());
    }
    public N endResource(){
            return and();
    }

}


}
