package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface TaskRunListFluent<A extends TaskRunListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,TaskRun item);
    public A setToItems(int index,TaskRun item);
    public A addToItems(TaskRun... items);
    public A addAllToItems(Collection<TaskRun> items);
    public A removeFromItems(TaskRun... items);
    public A removeAllFromItems(Collection<TaskRun> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<TaskRun> getItems();
    public List<TaskRun> buildItems();
    public TaskRun buildItem(int index);
    public TaskRun buildFirstItem();
    public TaskRun buildLastItem();
    public TaskRun buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<TaskRunBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<TaskRunBuilder> predicate);
    public A withItems(List<TaskRun> items);
    public A withItems(TaskRun... items);
    public Boolean hasItems();
    public TaskRunListFluent.ItemsNested<A> addNewItem();
    public TaskRunListFluent.ItemsNested<A> addNewItemLike(TaskRun item);
    public TaskRunListFluent.ItemsNested<A> setNewItemLike(int index,TaskRun item);
    public TaskRunListFluent.ItemsNested<A> editItem(int index);
    public TaskRunListFluent.ItemsNested<A> editFirstItem();
    public TaskRunListFluent.ItemsNested<A> editLastItem();
    public TaskRunListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<TaskRunBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TaskRunFluent<TaskRunListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
