package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface TaskRunOutputsFluent<A extends TaskRunOutputsFluent<A>> extends Fluent<A>{


    public A addToResources(int index,TaskResourceBinding item);
    public A setToResources(int index,TaskResourceBinding item);
    public A addToResources(TaskResourceBinding... items);
    public A addAllToResources(Collection<TaskResourceBinding> items);
    public A removeFromResources(TaskResourceBinding... items);
    public A removeAllFromResources(Collection<TaskResourceBinding> items);
    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public List<TaskResourceBinding> getResources();
    public List<TaskResourceBinding> buildResources();
    public TaskResourceBinding buildResource(int index);
    public TaskResourceBinding buildFirstResource();
    public TaskResourceBinding buildLastResource();
    public TaskResourceBinding buildMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<TaskResourceBindingBuilder> predicate);
    public Boolean hasMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<TaskResourceBindingBuilder> predicate);
    public A withResources(List<TaskResourceBinding> resources);
    public A withResources(TaskResourceBinding... resources);
    public Boolean hasResources();
    public TaskRunOutputsFluent.ResourcesNested<A> addNewResource();
    public TaskRunOutputsFluent.ResourcesNested<A> addNewResourceLike(TaskResourceBinding item);
    public TaskRunOutputsFluent.ResourcesNested<A> setNewResourceLike(int index,TaskResourceBinding item);
    public TaskRunOutputsFluent.ResourcesNested<A> editResource(int index);
    public TaskRunOutputsFluent.ResourcesNested<A> editFirstResource();
    public TaskRunOutputsFluent.ResourcesNested<A> editLastResource();
    public TaskRunOutputsFluent.ResourcesNested<A> editMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<TaskResourceBindingBuilder> predicate);

    public interface ResourcesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TaskResourceBindingFluent<TaskRunOutputsFluent.ResourcesNested<N>>{

        
    public N and();    public N endResource();
}


}
