package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class TaskRunOutputsFluentImpl<A extends TaskRunOutputsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TaskRunOutputsFluent<A>{

    private List<TaskResourceBindingBuilder> resources;

    public TaskRunOutputsFluentImpl(){
    }
    public TaskRunOutputsFluentImpl(TaskRunOutputs instance){
            this.withResources(instance.getResources()); 
    }

    public A addToResources(int index,TaskResourceBinding item){
            if (this.resources == null) {this.resources = new ArrayList<TaskResourceBindingBuilder>();}
            TaskResourceBindingBuilder builder = new TaskResourceBindingBuilder(item);_visitables.get("resources").add(index >= 0 ? index : _visitables.get("resources").size(), builder);this.resources.add(index >= 0 ? index : resources.size(), builder); return (A)this;
    }

    public A setToResources(int index,TaskResourceBinding item){
            if (this.resources == null) {this.resources = new ArrayList<TaskResourceBindingBuilder>();}
            TaskResourceBindingBuilder builder = new TaskResourceBindingBuilder(item);
            if (index < 0 || index >= _visitables.get("resources").size()) { _visitables.get("resources").add(builder); } else { _visitables.get("resources").set(index, builder);}
            if (index < 0 || index >= resources.size()) { resources.add(builder); } else { resources.set(index, builder);}
             return (A)this;
    }

    public A addToResources(TaskResourceBinding... items){
            if (this.resources == null) {this.resources = new ArrayList<TaskResourceBindingBuilder>();}
            for (TaskResourceBinding item : items) {TaskResourceBindingBuilder builder = new TaskResourceBindingBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
    }

    public A addAllToResources(Collection<TaskResourceBinding> items){
            if (this.resources == null) {this.resources = new ArrayList<TaskResourceBindingBuilder>();}
            for (TaskResourceBinding item : items) {TaskResourceBindingBuilder builder = new TaskResourceBindingBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
    }

    public A removeFromResources(TaskResourceBinding... items){
            for (TaskResourceBinding item : items) {TaskResourceBindingBuilder builder = new TaskResourceBindingBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
    }

    public A removeAllFromResources(Collection<TaskResourceBinding> items){
            for (TaskResourceBinding item : items) {TaskResourceBindingBuilder builder = new TaskResourceBindingBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public List<TaskResourceBinding> getResources(){
            return build(resources);
    }

    public List<TaskResourceBinding> buildResources(){
            return build(resources);
    }

    public TaskResourceBinding buildResource(int index){
            return this.resources.get(index).build();
    }

    public TaskResourceBinding buildFirstResource(){
            return this.resources.get(0).build();
    }

    public TaskResourceBinding buildLastResource(){
            return this.resources.get(resources.size() - 1).build();
    }

    public TaskResourceBinding buildMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<TaskResourceBindingBuilder> predicate){
            for (TaskResourceBindingBuilder item: resources) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<TaskResourceBindingBuilder> predicate){
            for (TaskResourceBindingBuilder item: resources) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withResources(List<TaskResourceBinding> resources){
            if (this.resources != null) { _visitables.get("resources").removeAll(this.resources);}
            if (resources != null) {this.resources = new ArrayList<TaskResourceBindingBuilder>(); for (TaskResourceBinding item : resources){this.addToResources(item);}} else { this.resources = new ArrayList<TaskResourceBindingBuilder>();} return (A) this;
    }

    public A withResources(TaskResourceBinding... resources){
            if (this.resources != null) {this.resources.clear();}
            if (resources != null) {for (TaskResourceBinding item :resources){ this.addToResources(item);}} return (A) this;
    }

    public Boolean hasResources(){
            return resources != null && !resources.isEmpty();
    }

    public TaskRunOutputsFluent.ResourcesNested<A> addNewResource(){
            return new ResourcesNestedImpl();
    }

    public TaskRunOutputsFluent.ResourcesNested<A> addNewResourceLike(TaskResourceBinding item){
            return new ResourcesNestedImpl(-1, item);
    }

    public TaskRunOutputsFluent.ResourcesNested<A> setNewResourceLike(int index,TaskResourceBinding item){
            return new ResourcesNestedImpl(index, item);
    }

    public TaskRunOutputsFluent.ResourcesNested<A> editResource(int index){
            if (resources.size() <= index) throw new RuntimeException("Can't edit resources. Index exceeds size.");
            return setNewResourceLike(index, buildResource(index));
    }

    public TaskRunOutputsFluent.ResourcesNested<A> editFirstResource(){
            if (resources.size() == 0) throw new RuntimeException("Can't edit first resources. The list is empty.");
            return setNewResourceLike(0, buildResource(0));
    }

    public TaskRunOutputsFluent.ResourcesNested<A> editLastResource(){
            int index = resources.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last resources. The list is empty.");
            return setNewResourceLike(index, buildResource(index));
    }

    public TaskRunOutputsFluent.ResourcesNested<A> editMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<TaskResourceBindingBuilder> predicate){
            int index = -1;
            for (int i=0;i<resources.size();i++) { 
            if (predicate.apply(resources.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching resources. No match found.");
            return setNewResourceLike(index, buildResource(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TaskRunOutputsFluentImpl that = (TaskRunOutputsFluentImpl) o;
            if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
            return true;
    }


    public class ResourcesNestedImpl<N> extends TaskResourceBindingFluentImpl<TaskRunOutputsFluent.ResourcesNested<N>> implements TaskRunOutputsFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TaskResourceBindingBuilder builder;
        private final int index;
    
            ResourcesNestedImpl(int index,TaskResourceBinding item){
                    this.index = index;
                    this.builder = new TaskResourceBindingBuilder(this, item);
            }
            ResourcesNestedImpl(){
                    this.index = -1;
                    this.builder = new TaskResourceBindingBuilder(this);
            }
    
    public N and(){
            return (N) TaskRunOutputsFluentImpl.this.setToResources(index, builder.build());
    }
    public N endResource(){
            return and();
    }

}


}
