package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class TaskRunSpecBuilder extends TaskRunSpecFluentImpl<TaskRunSpecBuilder> implements VisitableBuilder<TaskRunSpec,TaskRunSpecBuilder>{

    TaskRunSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TaskRunSpecBuilder(){
            this(true);
    }
    public TaskRunSpecBuilder(Boolean validationEnabled){
            this(new TaskRunSpec(), validationEnabled);
    }
    public TaskRunSpecBuilder(TaskRunSpecFluent<?> fluent){
            this(fluent, true);
    }
    public TaskRunSpecBuilder(TaskRunSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TaskRunSpec(), validationEnabled);
    }
    public TaskRunSpecBuilder(TaskRunSpecFluent<?> fluent,TaskRunSpec instance){
            this(fluent, instance, true);
    }
    public TaskRunSpecBuilder(TaskRunSpecFluent<?> fluent,TaskRunSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAffinity(instance.getAffinity()); 
            fluent.withInputs(instance.getInputs()); 
            fluent.withNodeSelector(instance.getNodeSelector()); 
            fluent.withOutputs(instance.getOutputs()); 
            fluent.withResults(instance.getResults()); 
            fluent.withServiceAccount(instance.getServiceAccount()); 
            fluent.withStatus(instance.getStatus()); 
            fluent.withTaskRef(instance.getTaskRef()); 
            fluent.withTaskSpec(instance.getTaskSpec()); 
            fluent.withTimeout(instance.getTimeout()); 
            fluent.withTolerations(instance.getTolerations()); 
            this.validationEnabled = validationEnabled; 
    }
    public TaskRunSpecBuilder(TaskRunSpec instance){
            this(instance,true);
    }
    public TaskRunSpecBuilder(TaskRunSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAffinity(instance.getAffinity()); 
            this.withInputs(instance.getInputs()); 
            this.withNodeSelector(instance.getNodeSelector()); 
            this.withOutputs(instance.getOutputs()); 
            this.withResults(instance.getResults()); 
            this.withServiceAccount(instance.getServiceAccount()); 
            this.withStatus(instance.getStatus()); 
            this.withTaskRef(instance.getTaskRef()); 
            this.withTaskSpec(instance.getTaskSpec()); 
            this.withTimeout(instance.getTimeout()); 
            this.withTolerations(instance.getTolerations()); 
            this.validationEnabled = validationEnabled; 
    }
    public TaskRunSpecBuilder(Validator validator){
            this(new TaskRunSpec(), true);
    }
    public TaskRunSpecBuilder(TaskRunSpecFluent<?> fluent,TaskRunSpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withAffinity(instance.getAffinity()); 
            fluent.withInputs(instance.getInputs()); 
            fluent.withNodeSelector(instance.getNodeSelector()); 
            fluent.withOutputs(instance.getOutputs()); 
            fluent.withResults(instance.getResults()); 
            fluent.withServiceAccount(instance.getServiceAccount()); 
            fluent.withStatus(instance.getStatus()); 
            fluent.withTaskRef(instance.getTaskRef()); 
            fluent.withTaskSpec(instance.getTaskSpec()); 
            fluent.withTimeout(instance.getTimeout()); 
            fluent.withTolerations(instance.getTolerations()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public TaskRunSpecBuilder(TaskRunSpec instance,Validator validator){
            this.fluent = this; 
            this.withAffinity(instance.getAffinity()); 
            this.withInputs(instance.getInputs()); 
            this.withNodeSelector(instance.getNodeSelector()); 
            this.withOutputs(instance.getOutputs()); 
            this.withResults(instance.getResults()); 
            this.withServiceAccount(instance.getServiceAccount()); 
            this.withStatus(instance.getStatus()); 
            this.withTaskRef(instance.getTaskRef()); 
            this.withTaskSpec(instance.getTaskSpec()); 
            this.withTimeout(instance.getTimeout()); 
            this.withTolerations(instance.getTolerations()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public TaskRunSpec build(){
            TaskRunSpec buildable = new TaskRunSpec(fluent.getAffinity(),fluent.getInputs(),fluent.getNodeSelector(),fluent.getOutputs(),fluent.getResults(),fluent.getServiceAccount(),fluent.getStatus(),fluent.getTaskRef(),fluent.getTaskSpec(),fluent.getTimeout(),fluent.getTolerations());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TaskRunSpecBuilder that = (TaskRunSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
