package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.v1.Condition;
import java.lang.StringBuffer;
import javax.validation.Valid;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

public class TaskRunStatusFluentImpl<A extends TaskRunStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TaskRunStatusFluent<A>{

    private String completionTime;
    private List<Condition> conditions;
    private Long observedGeneration;
    private String podName;
    private List<PipelineResourceResultBuilder> resourcesResult;
    private ResultsBuilder results;
    private List<TaskRunStatusBuilder> retriesStatus;
    private String startTime;
    private List<StepStateBuilder> steps;

    public TaskRunStatusFluentImpl(){
    }
    public TaskRunStatusFluentImpl(TaskRunStatus instance){
            this.withCompletionTime(instance.getCompletionTime()); 
            this.withConditions(instance.getConditions()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withPodName(instance.getPodName()); 
            this.withResourcesResult(instance.getResourcesResult()); 
            this.withResults(instance.getResults()); 
            this.withRetriesStatus(instance.getRetriesStatus()); 
            this.withStartTime(instance.getStartTime()); 
            this.withSteps(instance.getSteps()); 
    }

    public String getCompletionTime(){
            return this.completionTime;
    }

    public A withCompletionTime(String completionTime){
            this.completionTime=completionTime; return (A) this;
    }

    public Boolean hasCompletionTime(){
            return this.completionTime != null;
    }

    public A withNewCompletionTime(String arg1){
            return (A)withCompletionTime(new String(arg1));
    }

    public A withNewCompletionTime(StringBuilder arg1){
            return (A)withCompletionTime(new String(arg1));
    }

    public A withNewCompletionTime(StringBuffer arg1){
            return (A)withCompletionTime(new String(arg1));
    }

    public A addToConditions(int index,Condition item){
            if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
            this.conditions.add(index, item);
            return (A)this;
    }

    public A setToConditions(int index,Condition item){
            if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
            this.conditions.set(index, item); return (A)this;
    }

    public A addToConditions(Condition... items){
            if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
            for (Condition item : items) {this.conditions.add(item);} return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items){
            if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
            for (Condition item : items) {this.conditions.add(item);} return (A)this;
    }

    public A removeFromConditions(Condition... items){
            for (Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items){
            for (Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
    }

    public List<Condition> getConditions(){
            return this.conditions;
    }

    public Condition getCondition(int index){
            return this.conditions.get(index);
    }

    public Condition getFirstCondition(){
            return this.conditions.get(0);
    }

    public Condition getLastCondition(){
            return this.conditions.get(conditions.size() - 1);
    }

    public Condition getMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<Condition> predicate){
            for (Condition item: conditions) { if(predicate.apply(item)){return item;} } return null;
    }

    public Boolean hasMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<Condition> predicate){
            for (Condition item: conditions) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withConditions(List<Condition> conditions){
            if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
            if (conditions != null) {this.conditions = new ArrayList<Condition>(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = new ArrayList<Condition>();} return (A) this;
    }

    public A withConditions(Condition... conditions){
            if (this.conditions != null) {this.conditions.clear();}
            if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions(){
            return conditions != null && !conditions.isEmpty();
    }

    public Long getObservedGeneration(){
            return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration){
            this.observedGeneration=observedGeneration; return (A) this;
    }

    public Boolean hasObservedGeneration(){
            return this.observedGeneration != null;
    }

    public String getPodName(){
            return this.podName;
    }

    public A withPodName(String podName){
            this.podName=podName; return (A) this;
    }

    public Boolean hasPodName(){
            return this.podName != null;
    }

    public A withNewPodName(String arg1){
            return (A)withPodName(new String(arg1));
    }

    public A withNewPodName(StringBuilder arg1){
            return (A)withPodName(new String(arg1));
    }

    public A withNewPodName(StringBuffer arg1){
            return (A)withPodName(new String(arg1));
    }

    public A addToResourcesResult(int index,PipelineResourceResult item){
            if (this.resourcesResult == null) {this.resourcesResult = new ArrayList<PipelineResourceResultBuilder>();}
            PipelineResourceResultBuilder builder = new PipelineResourceResultBuilder(item);_visitables.get("resourcesResult").add(index >= 0 ? index : _visitables.get("resourcesResult").size(), builder);this.resourcesResult.add(index >= 0 ? index : resourcesResult.size(), builder); return (A)this;
    }

    public A setToResourcesResult(int index,PipelineResourceResult item){
            if (this.resourcesResult == null) {this.resourcesResult = new ArrayList<PipelineResourceResultBuilder>();}
            PipelineResourceResultBuilder builder = new PipelineResourceResultBuilder(item);
            if (index < 0 || index >= _visitables.get("resourcesResult").size()) { _visitables.get("resourcesResult").add(builder); } else { _visitables.get("resourcesResult").set(index, builder);}
            if (index < 0 || index >= resourcesResult.size()) { resourcesResult.add(builder); } else { resourcesResult.set(index, builder);}
             return (A)this;
    }

    public A addToResourcesResult(PipelineResourceResult... items){
            if (this.resourcesResult == null) {this.resourcesResult = new ArrayList<PipelineResourceResultBuilder>();}
            for (PipelineResourceResult item : items) {PipelineResourceResultBuilder builder = new PipelineResourceResultBuilder(item);_visitables.get("resourcesResult").add(builder);this.resourcesResult.add(builder);} return (A)this;
    }

    public A addAllToResourcesResult(Collection<PipelineResourceResult> items){
            if (this.resourcesResult == null) {this.resourcesResult = new ArrayList<PipelineResourceResultBuilder>();}
            for (PipelineResourceResult item : items) {PipelineResourceResultBuilder builder = new PipelineResourceResultBuilder(item);_visitables.get("resourcesResult").add(builder);this.resourcesResult.add(builder);} return (A)this;
    }

    public A removeFromResourcesResult(PipelineResourceResult... items){
            for (PipelineResourceResult item : items) {PipelineResourceResultBuilder builder = new PipelineResourceResultBuilder(item);_visitables.get("resourcesResult").remove(builder);if (this.resourcesResult != null) {this.resourcesResult.remove(builder);}} return (A)this;
    }

    public A removeAllFromResourcesResult(Collection<PipelineResourceResult> items){
            for (PipelineResourceResult item : items) {PipelineResourceResultBuilder builder = new PipelineResourceResultBuilder(item);_visitables.get("resourcesResult").remove(builder);if (this.resourcesResult != null) {this.resourcesResult.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildResourcesResult instead.
 * @return The buildable object.
 */
@Deprecated public List<PipelineResourceResult> getResourcesResult(){
            return build(resourcesResult);
    }

    public List<PipelineResourceResult> buildResourcesResult(){
            return build(resourcesResult);
    }

    public PipelineResourceResult buildResourcesResult(int index){
            return this.resourcesResult.get(index).build();
    }

    public PipelineResourceResult buildFirstResourcesResult(){
            return this.resourcesResult.get(0).build();
    }

    public PipelineResourceResult buildLastResourcesResult(){
            return this.resourcesResult.get(resourcesResult.size() - 1).build();
    }

    public PipelineResourceResult buildMatchingResourcesResult(io.fabric8.kubernetes.api.builder.Predicate<PipelineResourceResultBuilder> predicate){
            for (PipelineResourceResultBuilder item: resourcesResult) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingResourcesResult(io.fabric8.kubernetes.api.builder.Predicate<PipelineResourceResultBuilder> predicate){
            for (PipelineResourceResultBuilder item: resourcesResult) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withResourcesResult(List<PipelineResourceResult> resourcesResult){
            if (this.resourcesResult != null) { _visitables.get("resourcesResult").removeAll(this.resourcesResult);}
            if (resourcesResult != null) {this.resourcesResult = new ArrayList<PipelineResourceResultBuilder>(); for (PipelineResourceResult item : resourcesResult){this.addToResourcesResult(item);}} else { this.resourcesResult = new ArrayList<PipelineResourceResultBuilder>();} return (A) this;
    }

    public A withResourcesResult(PipelineResourceResult... resourcesResult){
            if (this.resourcesResult != null) {this.resourcesResult.clear();}
            if (resourcesResult != null) {for (PipelineResourceResult item :resourcesResult){ this.addToResourcesResult(item);}} return (A) this;
    }

    public Boolean hasResourcesResult(){
            return resourcesResult != null && !resourcesResult.isEmpty();
    }

    public A addNewResourcesResult(String digest,String name){
            return (A)addToResourcesResult(new PipelineResourceResult(digest, name));
    }

    public TaskRunStatusFluent.ResourcesResultNested<A> addNewResourcesResult(){
            return new ResourcesResultNestedImpl();
    }

    public TaskRunStatusFluent.ResourcesResultNested<A> addNewResourcesResultLike(PipelineResourceResult item){
            return new ResourcesResultNestedImpl(-1, item);
    }

    public TaskRunStatusFluent.ResourcesResultNested<A> setNewResourcesResultLike(int index,PipelineResourceResult item){
            return new ResourcesResultNestedImpl(index, item);
    }

    public TaskRunStatusFluent.ResourcesResultNested<A> editResourcesResult(int index){
            if (resourcesResult.size() <= index) throw new RuntimeException("Can't edit resourcesResult. Index exceeds size.");
            return setNewResourcesResultLike(index, buildResourcesResult(index));
    }

    public TaskRunStatusFluent.ResourcesResultNested<A> editFirstResourcesResult(){
            if (resourcesResult.size() == 0) throw new RuntimeException("Can't edit first resourcesResult. The list is empty.");
            return setNewResourcesResultLike(0, buildResourcesResult(0));
    }

    public TaskRunStatusFluent.ResourcesResultNested<A> editLastResourcesResult(){
            int index = resourcesResult.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last resourcesResult. The list is empty.");
            return setNewResourcesResultLike(index, buildResourcesResult(index));
    }

    public TaskRunStatusFluent.ResourcesResultNested<A> editMatchingResourcesResult(io.fabric8.kubernetes.api.builder.Predicate<PipelineResourceResultBuilder> predicate){
            int index = -1;
            for (int i=0;i<resourcesResult.size();i++) { 
            if (predicate.apply(resourcesResult.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching resourcesResult. No match found.");
            return setNewResourcesResultLike(index, buildResourcesResult(index));
    }

    
/**
 * This method has been deprecated, please use method buildResults instead.
 * @return The buildable object.
 */
@Deprecated public Results getResults(){
            return this.results!=null?this.results.build():null;
    }

    public Results buildResults(){
            return this.results!=null?this.results.build():null;
    }

    public A withResults(Results results){
            _visitables.get("results").remove(this.results);
            if (results!=null){ this.results= new ResultsBuilder(results); _visitables.get("results").add(this.results);} return (A) this;
    }

    public Boolean hasResults(){
            return this.results != null;
    }

    public A withNewResults(String type,String url){
            return (A)withResults(new Results(type, url));
    }

    public TaskRunStatusFluent.ResultsNested<A> withNewResults(){
            return new ResultsNestedImpl();
    }

    public TaskRunStatusFluent.ResultsNested<A> withNewResultsLike(Results item){
            return new ResultsNestedImpl(item);
    }

    public TaskRunStatusFluent.ResultsNested<A> editResults(){
            return withNewResultsLike(getResults());
    }

    public TaskRunStatusFluent.ResultsNested<A> editOrNewResults(){
            return withNewResultsLike(getResults() != null ? getResults(): new ResultsBuilder().build());
    }

    public TaskRunStatusFluent.ResultsNested<A> editOrNewResultsLike(Results item){
            return withNewResultsLike(getResults() != null ? getResults(): item);
    }

    public A addToRetriesStatus(int index,TaskRunStatus item){
            if (this.retriesStatus == null) {this.retriesStatus = new ArrayList<TaskRunStatusBuilder>();}
            TaskRunStatusBuilder builder = new TaskRunStatusBuilder(item);_visitables.get("retriesStatus").add(index >= 0 ? index : _visitables.get("retriesStatus").size(), builder);this.retriesStatus.add(index >= 0 ? index : retriesStatus.size(), builder); return (A)this;
    }

    public A setToRetriesStatus(int index,TaskRunStatus item){
            if (this.retriesStatus == null) {this.retriesStatus = new ArrayList<TaskRunStatusBuilder>();}
            TaskRunStatusBuilder builder = new TaskRunStatusBuilder(item);
            if (index < 0 || index >= _visitables.get("retriesStatus").size()) { _visitables.get("retriesStatus").add(builder); } else { _visitables.get("retriesStatus").set(index, builder);}
            if (index < 0 || index >= retriesStatus.size()) { retriesStatus.add(builder); } else { retriesStatus.set(index, builder);}
             return (A)this;
    }

    public A addToRetriesStatus(TaskRunStatus... items){
            if (this.retriesStatus == null) {this.retriesStatus = new ArrayList<TaskRunStatusBuilder>();}
            for (TaskRunStatus item : items) {TaskRunStatusBuilder builder = new TaskRunStatusBuilder(item);_visitables.get("retriesStatus").add(builder);this.retriesStatus.add(builder);} return (A)this;
    }

    public A addAllToRetriesStatus(Collection<TaskRunStatus> items){
            if (this.retriesStatus == null) {this.retriesStatus = new ArrayList<TaskRunStatusBuilder>();}
            for (TaskRunStatus item : items) {TaskRunStatusBuilder builder = new TaskRunStatusBuilder(item);_visitables.get("retriesStatus").add(builder);this.retriesStatus.add(builder);} return (A)this;
    }

    public A removeFromRetriesStatus(TaskRunStatus... items){
            for (TaskRunStatus item : items) {TaskRunStatusBuilder builder = new TaskRunStatusBuilder(item);_visitables.get("retriesStatus").remove(builder);if (this.retriesStatus != null) {this.retriesStatus.remove(builder);}} return (A)this;
    }

    public A removeAllFromRetriesStatus(Collection<TaskRunStatus> items){
            for (TaskRunStatus item : items) {TaskRunStatusBuilder builder = new TaskRunStatusBuilder(item);_visitables.get("retriesStatus").remove(builder);if (this.retriesStatus != null) {this.retriesStatus.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRetriesStatus instead.
 * @return The buildable object.
 */
@Deprecated public List<TaskRunStatus> getRetriesStatus(){
            return build(retriesStatus);
    }

    public List<TaskRunStatus> buildRetriesStatus(){
            return build(retriesStatus);
    }

    public TaskRunStatus buildRetriesStatus(int index){
            return this.retriesStatus.get(index).build();
    }

    public TaskRunStatus buildFirstRetriesStatus(){
            return this.retriesStatus.get(0).build();
    }

    public TaskRunStatus buildLastRetriesStatus(){
            return this.retriesStatus.get(retriesStatus.size() - 1).build();
    }

    public TaskRunStatus buildMatchingRetriesStatus(io.fabric8.kubernetes.api.builder.Predicate<TaskRunStatusBuilder> predicate){
            for (TaskRunStatusBuilder item: retriesStatus) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingRetriesStatus(io.fabric8.kubernetes.api.builder.Predicate<TaskRunStatusBuilder> predicate){
            for (TaskRunStatusBuilder item: retriesStatus) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withRetriesStatus(List<TaskRunStatus> retriesStatus){
            if (this.retriesStatus != null) { _visitables.get("retriesStatus").removeAll(this.retriesStatus);}
            if (retriesStatus != null) {this.retriesStatus = new ArrayList<TaskRunStatusBuilder>(); for (TaskRunStatus item : retriesStatus){this.addToRetriesStatus(item);}} else { this.retriesStatus = new ArrayList<TaskRunStatusBuilder>();} return (A) this;
    }

    public A withRetriesStatus(TaskRunStatus... retriesStatus){
            if (this.retriesStatus != null) {this.retriesStatus.clear();}
            if (retriesStatus != null) {for (TaskRunStatus item :retriesStatus){ this.addToRetriesStatus(item);}} return (A) this;
    }

    public Boolean hasRetriesStatus(){
            return retriesStatus != null && !retriesStatus.isEmpty();
    }

    public TaskRunStatusFluent.RetriesStatusNested<A> addNewRetriesStatus(){
            return new RetriesStatusNestedImpl();
    }

    public TaskRunStatusFluent.RetriesStatusNested<A> addNewRetriesStatusLike(TaskRunStatus item){
            return new RetriesStatusNestedImpl(-1, item);
    }

    public TaskRunStatusFluent.RetriesStatusNested<A> setNewRetriesStatusLike(int index,TaskRunStatus item){
            return new RetriesStatusNestedImpl(index, item);
    }

    public TaskRunStatusFluent.RetriesStatusNested<A> editRetriesStatus(int index){
            if (retriesStatus.size() <= index) throw new RuntimeException("Can't edit retriesStatus. Index exceeds size.");
            return setNewRetriesStatusLike(index, buildRetriesStatus(index));
    }

    public TaskRunStatusFluent.RetriesStatusNested<A> editFirstRetriesStatus(){
            if (retriesStatus.size() == 0) throw new RuntimeException("Can't edit first retriesStatus. The list is empty.");
            return setNewRetriesStatusLike(0, buildRetriesStatus(0));
    }

    public TaskRunStatusFluent.RetriesStatusNested<A> editLastRetriesStatus(){
            int index = retriesStatus.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last retriesStatus. The list is empty.");
            return setNewRetriesStatusLike(index, buildRetriesStatus(index));
    }

    public TaskRunStatusFluent.RetriesStatusNested<A> editMatchingRetriesStatus(io.fabric8.kubernetes.api.builder.Predicate<TaskRunStatusBuilder> predicate){
            int index = -1;
            for (int i=0;i<retriesStatus.size();i++) { 
            if (predicate.apply(retriesStatus.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching retriesStatus. No match found.");
            return setNewRetriesStatusLike(index, buildRetriesStatus(index));
    }

    public String getStartTime(){
            return this.startTime;
    }

    public A withStartTime(String startTime){
            this.startTime=startTime; return (A) this;
    }

    public Boolean hasStartTime(){
            return this.startTime != null;
    }

    public A withNewStartTime(String arg1){
            return (A)withStartTime(new String(arg1));
    }

    public A withNewStartTime(StringBuilder arg1){
            return (A)withStartTime(new String(arg1));
    }

    public A withNewStartTime(StringBuffer arg1){
            return (A)withStartTime(new String(arg1));
    }

    public A addToSteps(int index,StepState item){
            if (this.steps == null) {this.steps = new ArrayList<StepStateBuilder>();}
            StepStateBuilder builder = new StepStateBuilder(item);_visitables.get("steps").add(index >= 0 ? index : _visitables.get("steps").size(), builder);this.steps.add(index >= 0 ? index : steps.size(), builder); return (A)this;
    }

    public A setToSteps(int index,StepState item){
            if (this.steps == null) {this.steps = new ArrayList<StepStateBuilder>();}
            StepStateBuilder builder = new StepStateBuilder(item);
            if (index < 0 || index >= _visitables.get("steps").size()) { _visitables.get("steps").add(builder); } else { _visitables.get("steps").set(index, builder);}
            if (index < 0 || index >= steps.size()) { steps.add(builder); } else { steps.set(index, builder);}
             return (A)this;
    }

    public A addToSteps(StepState... items){
            if (this.steps == null) {this.steps = new ArrayList<StepStateBuilder>();}
            for (StepState item : items) {StepStateBuilder builder = new StepStateBuilder(item);_visitables.get("steps").add(builder);this.steps.add(builder);} return (A)this;
    }

    public A addAllToSteps(Collection<StepState> items){
            if (this.steps == null) {this.steps = new ArrayList<StepStateBuilder>();}
            for (StepState item : items) {StepStateBuilder builder = new StepStateBuilder(item);_visitables.get("steps").add(builder);this.steps.add(builder);} return (A)this;
    }

    public A removeFromSteps(StepState... items){
            for (StepState item : items) {StepStateBuilder builder = new StepStateBuilder(item);_visitables.get("steps").remove(builder);if (this.steps != null) {this.steps.remove(builder);}} return (A)this;
    }

    public A removeAllFromSteps(Collection<StepState> items){
            for (StepState item : items) {StepStateBuilder builder = new StepStateBuilder(item);_visitables.get("steps").remove(builder);if (this.steps != null) {this.steps.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSteps instead.
 * @return The buildable object.
 */
@Deprecated public List<StepState> getSteps(){
            return build(steps);
    }

    public List<StepState> buildSteps(){
            return build(steps);
    }

    public StepState buildStep(int index){
            return this.steps.get(index).build();
    }

    public StepState buildFirstStep(){
            return this.steps.get(0).build();
    }

    public StepState buildLastStep(){
            return this.steps.get(steps.size() - 1).build();
    }

    public StepState buildMatchingStep(io.fabric8.kubernetes.api.builder.Predicate<StepStateBuilder> predicate){
            for (StepStateBuilder item: steps) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingStep(io.fabric8.kubernetes.api.builder.Predicate<StepStateBuilder> predicate){
            for (StepStateBuilder item: steps) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withSteps(List<StepState> steps){
            if (this.steps != null) { _visitables.get("steps").removeAll(this.steps);}
            if (steps != null) {this.steps = new ArrayList<StepStateBuilder>(); for (StepState item : steps){this.addToSteps(item);}} else { this.steps = new ArrayList<StepStateBuilder>();} return (A) this;
    }

    public A withSteps(StepState... steps){
            if (this.steps != null) {this.steps.clear();}
            if (steps != null) {for (StepState item :steps){ this.addToSteps(item);}} return (A) this;
    }

    public Boolean hasSteps(){
            return steps != null && !steps.isEmpty();
    }

    public TaskRunStatusFluent.StepsNested<A> addNewStep(){
            return new StepsNestedImpl();
    }

    public TaskRunStatusFluent.StepsNested<A> addNewStepLike(StepState item){
            return new StepsNestedImpl(-1, item);
    }

    public TaskRunStatusFluent.StepsNested<A> setNewStepLike(int index,StepState item){
            return new StepsNestedImpl(index, item);
    }

    public TaskRunStatusFluent.StepsNested<A> editStep(int index){
            if (steps.size() <= index) throw new RuntimeException("Can't edit steps. Index exceeds size.");
            return setNewStepLike(index, buildStep(index));
    }

    public TaskRunStatusFluent.StepsNested<A> editFirstStep(){
            if (steps.size() == 0) throw new RuntimeException("Can't edit first steps. The list is empty.");
            return setNewStepLike(0, buildStep(0));
    }

    public TaskRunStatusFluent.StepsNested<A> editLastStep(){
            int index = steps.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last steps. The list is empty.");
            return setNewStepLike(index, buildStep(index));
    }

    public TaskRunStatusFluent.StepsNested<A> editMatchingStep(io.fabric8.kubernetes.api.builder.Predicate<StepStateBuilder> predicate){
            int index = -1;
            for (int i=0;i<steps.size();i++) { 
            if (predicate.apply(steps.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching steps. No match found.");
            return setNewStepLike(index, buildStep(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TaskRunStatusFluentImpl that = (TaskRunStatusFluentImpl) o;
            if (completionTime != null ? !completionTime.equals(that.completionTime) :that.completionTime != null) return false;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
            if (podName != null ? !podName.equals(that.podName) :that.podName != null) return false;
            if (resourcesResult != null ? !resourcesResult.equals(that.resourcesResult) :that.resourcesResult != null) return false;
            if (results != null ? !results.equals(that.results) :that.results != null) return false;
            if (retriesStatus != null ? !retriesStatus.equals(that.retriesStatus) :that.retriesStatus != null) return false;
            if (startTime != null ? !startTime.equals(that.startTime) :that.startTime != null) return false;
            if (steps != null ? !steps.equals(that.steps) :that.steps != null) return false;
            return true;
    }


    public class ResourcesResultNestedImpl<N> extends PipelineResourceResultFluentImpl<TaskRunStatusFluent.ResourcesResultNested<N>> implements TaskRunStatusFluent.ResourcesResultNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PipelineResourceResultBuilder builder;
        private final int index;
    
            ResourcesResultNestedImpl(int index,PipelineResourceResult item){
                    this.index = index;
                    this.builder = new PipelineResourceResultBuilder(this, item);
            }
            ResourcesResultNestedImpl(){
                    this.index = -1;
                    this.builder = new PipelineResourceResultBuilder(this);
            }
    
    public N and(){
            return (N) TaskRunStatusFluentImpl.this.setToResourcesResult(index, builder.build());
    }
    public N endResourcesResult(){
            return and();
    }

}
    public class ResultsNestedImpl<N> extends ResultsFluentImpl<TaskRunStatusFluent.ResultsNested<N>> implements TaskRunStatusFluent.ResultsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ResultsBuilder builder;
    
            ResultsNestedImpl(Results item){
                    this.builder = new ResultsBuilder(this, item);
            }
            ResultsNestedImpl(){
                    this.builder = new ResultsBuilder(this);
            }
    
    public N and(){
            return (N) TaskRunStatusFluentImpl.this.withResults(builder.build());
    }
    public N endResults(){
            return and();
    }

}
    public class RetriesStatusNestedImpl<N> extends TaskRunStatusFluentImpl<TaskRunStatusFluent.RetriesStatusNested<N>> implements TaskRunStatusFluent.RetriesStatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TaskRunStatusBuilder builder;
        private final int index;
    
            RetriesStatusNestedImpl(int index,TaskRunStatus item){
                    this.index = index;
                    this.builder = new TaskRunStatusBuilder(this, item);
            }
            RetriesStatusNestedImpl(){
                    this.index = -1;
                    this.builder = new TaskRunStatusBuilder(this);
            }
    
    public N and(){
            return (N) TaskRunStatusFluentImpl.this.setToRetriesStatus(index, builder.build());
    }
    public N endRetriesStatus(){
            return and();
    }

}
    public class StepsNestedImpl<N> extends StepStateFluentImpl<TaskRunStatusFluent.StepsNested<N>> implements TaskRunStatusFluent.StepsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final StepStateBuilder builder;
        private final int index;
    
            StepsNestedImpl(int index,StepState item){
                    this.index = index;
                    this.builder = new StepStateBuilder(this, item);
            }
            StepsNestedImpl(){
                    this.index = -1;
                    this.builder = new StepStateBuilder(this);
            }
    
    public N and(){
            return (N) TaskRunStatusFluentImpl.this.setToSteps(index, builder.build());
    }
    public N endStep(){
            return and();
    }

}


}
