package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class TaskSpecBuilder extends TaskSpecFluentImpl<TaskSpecBuilder> implements VisitableBuilder<TaskSpec,TaskSpecBuilder>{

    TaskSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TaskSpecBuilder(){
            this(true);
    }
    public TaskSpecBuilder(Boolean validationEnabled){
            this(new TaskSpec(), validationEnabled);
    }
    public TaskSpecBuilder(TaskSpecFluent<?> fluent){
            this(fluent, true);
    }
    public TaskSpecBuilder(TaskSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TaskSpec(), validationEnabled);
    }
    public TaskSpecBuilder(TaskSpecFluent<?> fluent,TaskSpec instance){
            this(fluent, instance, true);
    }
    public TaskSpecBuilder(TaskSpecFluent<?> fluent,TaskSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withContainerTemplate(instance.getContainerTemplate()); 
            fluent.withInputs(instance.getInputs()); 
            fluent.withOutputs(instance.getOutputs()); 
            fluent.withStepTemplate(instance.getStepTemplate()); 
            fluent.withSteps(instance.getSteps()); 
            fluent.withVolumes(instance.getVolumes()); 
            this.validationEnabled = validationEnabled; 
    }
    public TaskSpecBuilder(TaskSpec instance){
            this(instance,true);
    }
    public TaskSpecBuilder(TaskSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withContainerTemplate(instance.getContainerTemplate()); 
            this.withInputs(instance.getInputs()); 
            this.withOutputs(instance.getOutputs()); 
            this.withStepTemplate(instance.getStepTemplate()); 
            this.withSteps(instance.getSteps()); 
            this.withVolumes(instance.getVolumes()); 
            this.validationEnabled = validationEnabled; 
    }
    public TaskSpecBuilder(Validator validator){
            this(new TaskSpec(), true);
    }
    public TaskSpecBuilder(TaskSpecFluent<?> fluent,TaskSpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withContainerTemplate(instance.getContainerTemplate()); 
            fluent.withInputs(instance.getInputs()); 
            fluent.withOutputs(instance.getOutputs()); 
            fluent.withStepTemplate(instance.getStepTemplate()); 
            fluent.withSteps(instance.getSteps()); 
            fluent.withVolumes(instance.getVolumes()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public TaskSpecBuilder(TaskSpec instance,Validator validator){
            this.fluent = this; 
            this.withContainerTemplate(instance.getContainerTemplate()); 
            this.withInputs(instance.getInputs()); 
            this.withOutputs(instance.getOutputs()); 
            this.withStepTemplate(instance.getStepTemplate()); 
            this.withSteps(instance.getSteps()); 
            this.withVolumes(instance.getVolumes()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public TaskSpec build(){
            TaskSpec buildable = new TaskSpec(fluent.getContainerTemplate(),fluent.getInputs(),fluent.getOutputs(),fluent.getStepTemplate(),fluent.getSteps(),fluent.getVolumes());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TaskSpecBuilder that = (TaskSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
