package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.Container;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.Volume;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface TaskSpecFluent<A extends TaskSpecFluent<A>> extends Fluent<A>{


    public Container getContainerTemplate();
    public A withContainerTemplate(Container containerTemplate);
    public Boolean hasContainerTemplate();
    
/**
 * This method has been deprecated, please use method buildInputs instead.
 * @return The buildable object.
 */
@Deprecated public Inputs getInputs();
    public Inputs buildInputs();
    public A withInputs(Inputs inputs);
    public Boolean hasInputs();
    public TaskSpecFluent.InputsNested<A> withNewInputs();
    public TaskSpecFluent.InputsNested<A> withNewInputsLike(Inputs item);
    public TaskSpecFluent.InputsNested<A> editInputs();
    public TaskSpecFluent.InputsNested<A> editOrNewInputs();
    public TaskSpecFluent.InputsNested<A> editOrNewInputsLike(Inputs item);
    
/**
 * This method has been deprecated, please use method buildOutputs instead.
 * @return The buildable object.
 */
@Deprecated public Outputs getOutputs();
    public Outputs buildOutputs();
    public A withOutputs(Outputs outputs);
    public Boolean hasOutputs();
    public TaskSpecFluent.OutputsNested<A> withNewOutputs();
    public TaskSpecFluent.OutputsNested<A> withNewOutputsLike(Outputs item);
    public TaskSpecFluent.OutputsNested<A> editOutputs();
    public TaskSpecFluent.OutputsNested<A> editOrNewOutputs();
    public TaskSpecFluent.OutputsNested<A> editOrNewOutputsLike(Outputs item);
    public Container getStepTemplate();
    public A withStepTemplate(Container stepTemplate);
    public Boolean hasStepTemplate();
    public A addToSteps(int index,Container item);
    public A setToSteps(int index,Container item);
    public A addToSteps(Container... items);
    public A addAllToSteps(Collection<Container> items);
    public A removeFromSteps(Container... items);
    public A removeAllFromSteps(Collection<Container> items);
    public List<Container> getSteps();
    public Container getStep(int index);
    public Container getFirstStep();
    public Container getLastStep();
    public Container getMatchingStep(io.fabric8.kubernetes.api.builder.Predicate<Container> predicate);
    public Boolean hasMatchingStep(io.fabric8.kubernetes.api.builder.Predicate<Container> predicate);
    public A withSteps(List<Container> steps);
    public A withSteps(Container... steps);
    public Boolean hasSteps();
    public A addToVolumes(int index,Volume item);
    public A setToVolumes(int index,Volume item);
    public A addToVolumes(Volume... items);
    public A addAllToVolumes(Collection<Volume> items);
    public A removeFromVolumes(Volume... items);
    public A removeAllFromVolumes(Collection<Volume> items);
    public List<Volume> getVolumes();
    public Volume getVolume(int index);
    public Volume getFirstVolume();
    public Volume getLastVolume();
    public Volume getMatchingVolume(io.fabric8.kubernetes.api.builder.Predicate<Volume> predicate);
    public Boolean hasMatchingVolume(io.fabric8.kubernetes.api.builder.Predicate<Volume> predicate);
    public A withVolumes(List<Volume> volumes);
    public A withVolumes(Volume... volumes);
    public Boolean hasVolumes();

    public interface InputsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,InputsFluent<TaskSpecFluent.InputsNested<N>>{

        
    public N and();    public N endInputs();
}
    public interface OutputsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OutputsFluent<TaskSpecFluent.OutputsNested<N>>{

        
    public N and();    public N endOutputs();
}


}
