package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.Container;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.Volume;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;

public class TaskSpecFluentImpl<A extends TaskSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TaskSpecFluent<A>{

    private Container containerTemplate;
    private InputsBuilder inputs;
    private OutputsBuilder outputs;
    private Container stepTemplate;
    private List<Container> steps;
    private List<Volume> volumes;

    public TaskSpecFluentImpl(){
    }
    public TaskSpecFluentImpl(TaskSpec instance){
            this.withContainerTemplate(instance.getContainerTemplate()); 
            this.withInputs(instance.getInputs()); 
            this.withOutputs(instance.getOutputs()); 
            this.withStepTemplate(instance.getStepTemplate()); 
            this.withSteps(instance.getSteps()); 
            this.withVolumes(instance.getVolumes()); 
    }

    public Container getContainerTemplate(){
            return this.containerTemplate;
    }

    public A withContainerTemplate(Container containerTemplate){
            this.containerTemplate=containerTemplate; return (A) this;
    }

    public Boolean hasContainerTemplate(){
            return this.containerTemplate != null;
    }

    
/**
 * This method has been deprecated, please use method buildInputs instead.
 * @return The buildable object.
 */
@Deprecated public Inputs getInputs(){
            return this.inputs!=null?this.inputs.build():null;
    }

    public Inputs buildInputs(){
            return this.inputs!=null?this.inputs.build():null;
    }

    public A withInputs(Inputs inputs){
            _visitables.get("inputs").remove(this.inputs);
            if (inputs!=null){ this.inputs= new InputsBuilder(inputs); _visitables.get("inputs").add(this.inputs);} return (A) this;
    }

    public Boolean hasInputs(){
            return this.inputs != null;
    }

    public TaskSpecFluent.InputsNested<A> withNewInputs(){
            return new InputsNestedImpl();
    }

    public TaskSpecFluent.InputsNested<A> withNewInputsLike(Inputs item){
            return new InputsNestedImpl(item);
    }

    public TaskSpecFluent.InputsNested<A> editInputs(){
            return withNewInputsLike(getInputs());
    }

    public TaskSpecFluent.InputsNested<A> editOrNewInputs(){
            return withNewInputsLike(getInputs() != null ? getInputs(): new InputsBuilder().build());
    }

    public TaskSpecFluent.InputsNested<A> editOrNewInputsLike(Inputs item){
            return withNewInputsLike(getInputs() != null ? getInputs(): item);
    }

    
/**
 * This method has been deprecated, please use method buildOutputs instead.
 * @return The buildable object.
 */
@Deprecated public Outputs getOutputs(){
            return this.outputs!=null?this.outputs.build():null;
    }

    public Outputs buildOutputs(){
            return this.outputs!=null?this.outputs.build():null;
    }

    public A withOutputs(Outputs outputs){
            _visitables.get("outputs").remove(this.outputs);
            if (outputs!=null){ this.outputs= new OutputsBuilder(outputs); _visitables.get("outputs").add(this.outputs);} return (A) this;
    }

    public Boolean hasOutputs(){
            return this.outputs != null;
    }

    public TaskSpecFluent.OutputsNested<A> withNewOutputs(){
            return new OutputsNestedImpl();
    }

    public TaskSpecFluent.OutputsNested<A> withNewOutputsLike(Outputs item){
            return new OutputsNestedImpl(item);
    }

    public TaskSpecFluent.OutputsNested<A> editOutputs(){
            return withNewOutputsLike(getOutputs());
    }

    public TaskSpecFluent.OutputsNested<A> editOrNewOutputs(){
            return withNewOutputsLike(getOutputs() != null ? getOutputs(): new OutputsBuilder().build());
    }

    public TaskSpecFluent.OutputsNested<A> editOrNewOutputsLike(Outputs item){
            return withNewOutputsLike(getOutputs() != null ? getOutputs(): item);
    }

    public Container getStepTemplate(){
            return this.stepTemplate;
    }

    public A withStepTemplate(Container stepTemplate){
            this.stepTemplate=stepTemplate; return (A) this;
    }

    public Boolean hasStepTemplate(){
            return this.stepTemplate != null;
    }

    public A addToSteps(int index,Container item){
            if (this.steps == null) {this.steps = new ArrayList<Container>();}
            this.steps.add(index, item);
            return (A)this;
    }

    public A setToSteps(int index,Container item){
            if (this.steps == null) {this.steps = new ArrayList<Container>();}
            this.steps.set(index, item); return (A)this;
    }

    public A addToSteps(Container... items){
            if (this.steps == null) {this.steps = new ArrayList<Container>();}
            for (Container item : items) {this.steps.add(item);} return (A)this;
    }

    public A addAllToSteps(Collection<Container> items){
            if (this.steps == null) {this.steps = new ArrayList<Container>();}
            for (Container item : items) {this.steps.add(item);} return (A)this;
    }

    public A removeFromSteps(Container... items){
            for (Container item : items) {if (this.steps!= null){ this.steps.remove(item);}} return (A)this;
    }

    public A removeAllFromSteps(Collection<Container> items){
            for (Container item : items) {if (this.steps!= null){ this.steps.remove(item);}} return (A)this;
    }

    public List<Container> getSteps(){
            return this.steps;
    }

    public Container getStep(int index){
            return this.steps.get(index);
    }

    public Container getFirstStep(){
            return this.steps.get(0);
    }

    public Container getLastStep(){
            return this.steps.get(steps.size() - 1);
    }

    public Container getMatchingStep(io.fabric8.kubernetes.api.builder.Predicate<Container> predicate){
            for (Container item: steps) { if(predicate.apply(item)){return item;} } return null;
    }

    public Boolean hasMatchingStep(io.fabric8.kubernetes.api.builder.Predicate<Container> predicate){
            for (Container item: steps) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withSteps(List<Container> steps){
            if (this.steps != null) { _visitables.get("steps").removeAll(this.steps);}
            if (steps != null) {this.steps = new ArrayList<Container>(); for (Container item : steps){this.addToSteps(item);}} else { this.steps = new ArrayList<Container>();} return (A) this;
    }

    public A withSteps(Container... steps){
            if (this.steps != null) {this.steps.clear();}
            if (steps != null) {for (Container item :steps){ this.addToSteps(item);}} return (A) this;
    }

    public Boolean hasSteps(){
            return steps != null && !steps.isEmpty();
    }

    public A addToVolumes(int index,Volume item){
            if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
            this.volumes.add(index, item);
            return (A)this;
    }

    public A setToVolumes(int index,Volume item){
            if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
            this.volumes.set(index, item); return (A)this;
    }

    public A addToVolumes(Volume... items){
            if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
            for (Volume item : items) {this.volumes.add(item);} return (A)this;
    }

    public A addAllToVolumes(Collection<Volume> items){
            if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
            for (Volume item : items) {this.volumes.add(item);} return (A)this;
    }

    public A removeFromVolumes(Volume... items){
            for (Volume item : items) {if (this.volumes!= null){ this.volumes.remove(item);}} return (A)this;
    }

    public A removeAllFromVolumes(Collection<Volume> items){
            for (Volume item : items) {if (this.volumes!= null){ this.volumes.remove(item);}} return (A)this;
    }

    public List<Volume> getVolumes(){
            return this.volumes;
    }

    public Volume getVolume(int index){
            return this.volumes.get(index);
    }

    public Volume getFirstVolume(){
            return this.volumes.get(0);
    }

    public Volume getLastVolume(){
            return this.volumes.get(volumes.size() - 1);
    }

    public Volume getMatchingVolume(io.fabric8.kubernetes.api.builder.Predicate<Volume> predicate){
            for (Volume item: volumes) { if(predicate.apply(item)){return item;} } return null;
    }

    public Boolean hasMatchingVolume(io.fabric8.kubernetes.api.builder.Predicate<Volume> predicate){
            for (Volume item: volumes) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withVolumes(List<Volume> volumes){
            if (this.volumes != null) { _visitables.get("volumes").removeAll(this.volumes);}
            if (volumes != null) {this.volumes = new ArrayList<Volume>(); for (Volume item : volumes){this.addToVolumes(item);}} else { this.volumes = new ArrayList<Volume>();} return (A) this;
    }

    public A withVolumes(Volume... volumes){
            if (this.volumes != null) {this.volumes.clear();}
            if (volumes != null) {for (Volume item :volumes){ this.addToVolumes(item);}} return (A) this;
    }

    public Boolean hasVolumes(){
            return volumes != null && !volumes.isEmpty();
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TaskSpecFluentImpl that = (TaskSpecFluentImpl) o;
            if (containerTemplate != null ? !containerTemplate.equals(that.containerTemplate) :that.containerTemplate != null) return false;
            if (inputs != null ? !inputs.equals(that.inputs) :that.inputs != null) return false;
            if (outputs != null ? !outputs.equals(that.outputs) :that.outputs != null) return false;
            if (stepTemplate != null ? !stepTemplate.equals(that.stepTemplate) :that.stepTemplate != null) return false;
            if (steps != null ? !steps.equals(that.steps) :that.steps != null) return false;
            if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
            return true;
    }


    public class InputsNestedImpl<N> extends InputsFluentImpl<TaskSpecFluent.InputsNested<N>> implements TaskSpecFluent.InputsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final InputsBuilder builder;
    
            InputsNestedImpl(Inputs item){
                    this.builder = new InputsBuilder(this, item);
            }
            InputsNestedImpl(){
                    this.builder = new InputsBuilder(this);
            }
    
    public N and(){
            return (N) TaskSpecFluentImpl.this.withInputs(builder.build());
    }
    public N endInputs(){
            return and();
    }

}
    public class OutputsNestedImpl<N> extends OutputsFluentImpl<TaskSpecFluent.OutputsNested<N>> implements TaskSpecFluent.OutputsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OutputsBuilder builder;
    
            OutputsNestedImpl(Outputs item){
                    this.builder = new OutputsBuilder(this, item);
            }
            OutputsNestedImpl(){
                    this.builder = new OutputsBuilder(this);
            }
    
    public N and(){
            return (N) TaskSpecFluentImpl.this.withOutputs(builder.build());
    }
    public N endOutputs(){
            return and();
    }

}


}
