package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.constraints.NotNull;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface ClusterTaskFluent<A extends ClusterTaskFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public ClusterTaskFluent.MetadataNested<A> withNewMetadata();
    public ClusterTaskFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ClusterTaskFluent.MetadataNested<A> editMetadata();
    public ClusterTaskFluent.MetadataNested<A> editOrNewMetadata();
    public ClusterTaskFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public TaskSpec getSpec();
    public TaskSpec buildSpec();
    public A withSpec(TaskSpec spec);
    public Boolean hasSpec();
    public ClusterTaskFluent.SpecNested<A> withNewSpec();
    public ClusterTaskFluent.SpecNested<A> withNewSpecLike(TaskSpec item);
    public ClusterTaskFluent.SpecNested<A> editSpec();
    public ClusterTaskFluent.SpecNested<A> editOrNewSpec();
    public ClusterTaskFluent.SpecNested<A> editOrNewSpecLike(TaskSpec item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ClusterTaskFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TaskSpecFluent<ClusterTaskFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
