package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ClusterTaskListBuilder extends ClusterTaskListFluentImpl<ClusterTaskListBuilder> implements VisitableBuilder<ClusterTaskList,ClusterTaskListBuilder>{

    ClusterTaskListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ClusterTaskListBuilder(){
            this(true);
    }
    public ClusterTaskListBuilder(Boolean validationEnabled){
            this(new ClusterTaskList(), validationEnabled);
    }
    public ClusterTaskListBuilder(ClusterTaskListFluent<?> fluent){
            this(fluent, true);
    }
    public ClusterTaskListBuilder(ClusterTaskListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ClusterTaskList(), validationEnabled);
    }
    public ClusterTaskListBuilder(ClusterTaskListFluent<?> fluent,ClusterTaskList instance){
            this(fluent, instance, true);
    }
    public ClusterTaskListBuilder(ClusterTaskListFluent<?> fluent,ClusterTaskList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public ClusterTaskListBuilder(ClusterTaskList instance){
            this(instance,true);
    }
    public ClusterTaskListBuilder(ClusterTaskList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public ClusterTaskListBuilder(Validator validator){
            this(new ClusterTaskList(), true);
    }
    public ClusterTaskListBuilder(ClusterTaskListFluent<?> fluent,ClusterTaskList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ClusterTaskListBuilder(ClusterTaskList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ClusterTaskList build(){
            ClusterTaskList buildable = new ClusterTaskList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ClusterTaskListBuilder that = (ClusterTaskListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
