package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ClusterTaskListFluent<A extends ClusterTaskListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,ClusterTask item);
    public A setToItems(int index,ClusterTask item);
    public A addToItems(ClusterTask... items);
    public A addAllToItems(Collection<ClusterTask> items);
    public A removeFromItems(ClusterTask... items);
    public A removeAllFromItems(Collection<ClusterTask> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<ClusterTask> getItems();
    public List<ClusterTask> buildItems();
    public ClusterTask buildItem(int index);
    public ClusterTask buildFirstItem();
    public ClusterTask buildLastItem();
    public ClusterTask buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ClusterTaskBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ClusterTaskBuilder> predicate);
    public A withItems(List<ClusterTask> items);
    public A withItems(ClusterTask... items);
    public Boolean hasItems();
    public ClusterTaskListFluent.ItemsNested<A> addNewItem();
    public ClusterTaskListFluent.ItemsNested<A> addNewItemLike(ClusterTask item);
    public ClusterTaskListFluent.ItemsNested<A> setNewItemLike(int index,ClusterTask item);
    public ClusterTaskListFluent.ItemsNested<A> editItem(int index);
    public ClusterTaskListFluent.ItemsNested<A> editFirstItem();
    public ClusterTaskListFluent.ItemsNested<A> editLastItem();
    public ClusterTaskListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ClusterTaskBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterTaskFluent<ClusterTaskListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
