package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class InputsBuilder extends InputsFluentImpl<InputsBuilder> implements VisitableBuilder<Inputs,InputsBuilder>{

    InputsFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public InputsBuilder(){
            this(true);
    }
    public InputsBuilder(Boolean validationEnabled){
            this(new Inputs(), validationEnabled);
    }
    public InputsBuilder(InputsFluent<?> fluent){
            this(fluent, true);
    }
    public InputsBuilder(InputsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Inputs(), validationEnabled);
    }
    public InputsBuilder(InputsFluent<?> fluent,Inputs instance){
            this(fluent, instance, true);
    }
    public InputsBuilder(InputsFluent<?> fluent,Inputs instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withParams(instance.getParams()); 
            fluent.withResources(instance.getResources()); 
            this.validationEnabled = validationEnabled; 
    }
    public InputsBuilder(Inputs instance){
            this(instance,true);
    }
    public InputsBuilder(Inputs instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withParams(instance.getParams()); 
            this.withResources(instance.getResources()); 
            this.validationEnabled = validationEnabled; 
    }
    public InputsBuilder(Validator validator){
            this(new Inputs(), true);
    }
    public InputsBuilder(InputsFluent<?> fluent,Inputs instance,Validator validator){
            this.fluent = fluent; 
            fluent.withParams(instance.getParams()); 
            fluent.withResources(instance.getResources()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public InputsBuilder(Inputs instance,Validator validator){
            this.fluent = this; 
            this.withParams(instance.getParams()); 
            this.withResources(instance.getResources()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Inputs build(){
            Inputs buildable = new Inputs(fluent.getParams(),fluent.getResources());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            InputsBuilder that = (InputsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
