package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;

public class InputsFluentImpl<A extends InputsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements InputsFluent<A>{

    private List<ParamSpecBuilder> params;
    private List<TaskResourceBuilder> resources;

    public InputsFluentImpl(){
    }
    public InputsFluentImpl(Inputs instance){
            this.withParams(instance.getParams()); 
            this.withResources(instance.getResources()); 
    }

    public A addToParams(int index,ParamSpec item){
            if (this.params == null) {this.params = new ArrayList<ParamSpecBuilder>();}
            ParamSpecBuilder builder = new ParamSpecBuilder(item);_visitables.get("params").add(index >= 0 ? index : _visitables.get("params").size(), builder);this.params.add(index >= 0 ? index : params.size(), builder); return (A)this;
    }

    public A setToParams(int index,ParamSpec item){
            if (this.params == null) {this.params = new ArrayList<ParamSpecBuilder>();}
            ParamSpecBuilder builder = new ParamSpecBuilder(item);
            if (index < 0 || index >= _visitables.get("params").size()) { _visitables.get("params").add(builder); } else { _visitables.get("params").set(index, builder);}
            if (index < 0 || index >= params.size()) { params.add(builder); } else { params.set(index, builder);}
             return (A)this;
    }

    public A addToParams(ParamSpec... items){
            if (this.params == null) {this.params = new ArrayList<ParamSpecBuilder>();}
            for (ParamSpec item : items) {ParamSpecBuilder builder = new ParamSpecBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
    }

    public A addAllToParams(Collection<ParamSpec> items){
            if (this.params == null) {this.params = new ArrayList<ParamSpecBuilder>();}
            for (ParamSpec item : items) {ParamSpecBuilder builder = new ParamSpecBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
    }

    public A removeFromParams(ParamSpec... items){
            for (ParamSpec item : items) {ParamSpecBuilder builder = new ParamSpecBuilder(item);_visitables.get("params").remove(builder);if (this.params != null) {this.params.remove(builder);}} return (A)this;
    }

    public A removeAllFromParams(Collection<ParamSpec> items){
            for (ParamSpec item : items) {ParamSpecBuilder builder = new ParamSpecBuilder(item);_visitables.get("params").remove(builder);if (this.params != null) {this.params.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildParams instead.
 * @return The buildable object.
 */
@Deprecated public List<ParamSpec> getParams(){
            return build(params);
    }

    public List<ParamSpec> buildParams(){
            return build(params);
    }

    public ParamSpec buildParam(int index){
            return this.params.get(index).build();
    }

    public ParamSpec buildFirstParam(){
            return this.params.get(0).build();
    }

    public ParamSpec buildLastParam(){
            return this.params.get(params.size() - 1).build();
    }

    public ParamSpec buildMatchingParam(io.fabric8.kubernetes.api.builder.Predicate<ParamSpecBuilder> predicate){
            for (ParamSpecBuilder item: params) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingParam(io.fabric8.kubernetes.api.builder.Predicate<ParamSpecBuilder> predicate){
            for (ParamSpecBuilder item: params) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withParams(List<ParamSpec> params){
            if (this.params != null) { _visitables.get("params").removeAll(this.params);}
            if (params != null) {this.params = new ArrayList<ParamSpecBuilder>(); for (ParamSpec item : params){this.addToParams(item);}} else { this.params = new ArrayList<ParamSpecBuilder>();} return (A) this;
    }

    public A withParams(ParamSpec... params){
            if (this.params != null) {this.params.clear();}
            if (params != null) {for (ParamSpec item :params){ this.addToParams(item);}} return (A) this;
    }

    public Boolean hasParams(){
            return params != null && !params.isEmpty();
    }

    public A addNewParam(String _default,String description,String name){
            return (A)addToParams(new ParamSpec(_default, description, name));
    }

    public InputsFluent.ParamsNested<A> addNewParam(){
            return new ParamsNestedImpl();
    }

    public InputsFluent.ParamsNested<A> addNewParamLike(ParamSpec item){
            return new ParamsNestedImpl(-1, item);
    }

    public InputsFluent.ParamsNested<A> setNewParamLike(int index,ParamSpec item){
            return new ParamsNestedImpl(index, item);
    }

    public InputsFluent.ParamsNested<A> editParam(int index){
            if (params.size() <= index) throw new RuntimeException("Can't edit params. Index exceeds size.");
            return setNewParamLike(index, buildParam(index));
    }

    public InputsFluent.ParamsNested<A> editFirstParam(){
            if (params.size() == 0) throw new RuntimeException("Can't edit first params. The list is empty.");
            return setNewParamLike(0, buildParam(0));
    }

    public InputsFluent.ParamsNested<A> editLastParam(){
            int index = params.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last params. The list is empty.");
            return setNewParamLike(index, buildParam(index));
    }

    public InputsFluent.ParamsNested<A> editMatchingParam(io.fabric8.kubernetes.api.builder.Predicate<ParamSpecBuilder> predicate){
            int index = -1;
            for (int i=0;i<params.size();i++) { 
            if (predicate.apply(params.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching params. No match found.");
            return setNewParamLike(index, buildParam(index));
    }

    public A addToResources(int index,TaskResource item){
            if (this.resources == null) {this.resources = new ArrayList<TaskResourceBuilder>();}
            TaskResourceBuilder builder = new TaskResourceBuilder(item);_visitables.get("resources").add(index >= 0 ? index : _visitables.get("resources").size(), builder);this.resources.add(index >= 0 ? index : resources.size(), builder); return (A)this;
    }

    public A setToResources(int index,TaskResource item){
            if (this.resources == null) {this.resources = new ArrayList<TaskResourceBuilder>();}
            TaskResourceBuilder builder = new TaskResourceBuilder(item);
            if (index < 0 || index >= _visitables.get("resources").size()) { _visitables.get("resources").add(builder); } else { _visitables.get("resources").set(index, builder);}
            if (index < 0 || index >= resources.size()) { resources.add(builder); } else { resources.set(index, builder);}
             return (A)this;
    }

    public A addToResources(TaskResource... items){
            if (this.resources == null) {this.resources = new ArrayList<TaskResourceBuilder>();}
            for (TaskResource item : items) {TaskResourceBuilder builder = new TaskResourceBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
    }

    public A addAllToResources(Collection<TaskResource> items){
            if (this.resources == null) {this.resources = new ArrayList<TaskResourceBuilder>();}
            for (TaskResource item : items) {TaskResourceBuilder builder = new TaskResourceBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
    }

    public A removeFromResources(TaskResource... items){
            for (TaskResource item : items) {TaskResourceBuilder builder = new TaskResourceBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
    }

    public A removeAllFromResources(Collection<TaskResource> items){
            for (TaskResource item : items) {TaskResourceBuilder builder = new TaskResourceBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public List<TaskResource> getResources(){
            return build(resources);
    }

    public List<TaskResource> buildResources(){
            return build(resources);
    }

    public TaskResource buildResource(int index){
            return this.resources.get(index).build();
    }

    public TaskResource buildFirstResource(){
            return this.resources.get(0).build();
    }

    public TaskResource buildLastResource(){
            return this.resources.get(resources.size() - 1).build();
    }

    public TaskResource buildMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<TaskResourceBuilder> predicate){
            for (TaskResourceBuilder item: resources) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<TaskResourceBuilder> predicate){
            for (TaskResourceBuilder item: resources) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withResources(List<TaskResource> resources){
            if (this.resources != null) { _visitables.get("resources").removeAll(this.resources);}
            if (resources != null) {this.resources = new ArrayList<TaskResourceBuilder>(); for (TaskResource item : resources){this.addToResources(item);}} else { this.resources = new ArrayList<TaskResourceBuilder>();} return (A) this;
    }

    public A withResources(TaskResource... resources){
            if (this.resources != null) {this.resources.clear();}
            if (resources != null) {for (TaskResource item :resources){ this.addToResources(item);}} return (A) this;
    }

    public Boolean hasResources(){
            return resources != null && !resources.isEmpty();
    }

    public A addNewResource(String name,String outputImageDir,String targetPath,String type){
            return (A)addToResources(new TaskResource(name, outputImageDir, targetPath, type));
    }

    public InputsFluent.ResourcesNested<A> addNewResource(){
            return new ResourcesNestedImpl();
    }

    public InputsFluent.ResourcesNested<A> addNewResourceLike(TaskResource item){
            return new ResourcesNestedImpl(-1, item);
    }

    public InputsFluent.ResourcesNested<A> setNewResourceLike(int index,TaskResource item){
            return new ResourcesNestedImpl(index, item);
    }

    public InputsFluent.ResourcesNested<A> editResource(int index){
            if (resources.size() <= index) throw new RuntimeException("Can't edit resources. Index exceeds size.");
            return setNewResourceLike(index, buildResource(index));
    }

    public InputsFluent.ResourcesNested<A> editFirstResource(){
            if (resources.size() == 0) throw new RuntimeException("Can't edit first resources. The list is empty.");
            return setNewResourceLike(0, buildResource(0));
    }

    public InputsFluent.ResourcesNested<A> editLastResource(){
            int index = resources.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last resources. The list is empty.");
            return setNewResourceLike(index, buildResource(index));
    }

    public InputsFluent.ResourcesNested<A> editMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<TaskResourceBuilder> predicate){
            int index = -1;
            for (int i=0;i<resources.size();i++) { 
            if (predicate.apply(resources.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching resources. No match found.");
            return setNewResourceLike(index, buildResource(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            InputsFluentImpl that = (InputsFluentImpl) o;
            if (params != null ? !params.equals(that.params) :that.params != null) return false;
            if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
            return true;
    }


    public class ParamsNestedImpl<N> extends ParamSpecFluentImpl<InputsFluent.ParamsNested<N>> implements InputsFluent.ParamsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ParamSpecBuilder builder;
        private final int index;
    
            ParamsNestedImpl(int index,ParamSpec item){
                    this.index = index;
                    this.builder = new ParamSpecBuilder(this, item);
            }
            ParamsNestedImpl(){
                    this.index = -1;
                    this.builder = new ParamSpecBuilder(this);
            }
    
    public N and(){
            return (N) InputsFluentImpl.this.setToParams(index, builder.build());
    }
    public N endParam(){
            return and();
    }

}
    public class ResourcesNestedImpl<N> extends TaskResourceFluentImpl<InputsFluent.ResourcesNested<N>> implements InputsFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TaskResourceBuilder builder;
        private final int index;
    
            ResourcesNestedImpl(int index,TaskResource item){
                    this.index = index;
                    this.builder = new TaskResourceBuilder(this, item);
            }
            ResourcesNestedImpl(){
                    this.index = -1;
                    this.builder = new TaskResourceBuilder(this);
            }
    
    public N and(){
            return (N) InputsFluentImpl.this.setToResources(index, builder.build());
    }
    public N endResource(){
            return and();
    }

}


}
