package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class OutputsBuilder extends OutputsFluentImpl<OutputsBuilder> implements VisitableBuilder<Outputs,OutputsBuilder>{

    OutputsFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public OutputsBuilder(){
            this(true);
    }
    public OutputsBuilder(Boolean validationEnabled){
            this(new Outputs(), validationEnabled);
    }
    public OutputsBuilder(OutputsFluent<?> fluent){
            this(fluent, true);
    }
    public OutputsBuilder(OutputsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Outputs(), validationEnabled);
    }
    public OutputsBuilder(OutputsFluent<?> fluent,Outputs instance){
            this(fluent, instance, true);
    }
    public OutputsBuilder(OutputsFluent<?> fluent,Outputs instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withResources(instance.getResources()); 
            fluent.withResults(instance.getResults()); 
            this.validationEnabled = validationEnabled; 
    }
    public OutputsBuilder(Outputs instance){
            this(instance,true);
    }
    public OutputsBuilder(Outputs instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withResources(instance.getResources()); 
            this.withResults(instance.getResults()); 
            this.validationEnabled = validationEnabled; 
    }
    public OutputsBuilder(Validator validator){
            this(new Outputs(), true);
    }
    public OutputsBuilder(OutputsFluent<?> fluent,Outputs instance,Validator validator){
            this.fluent = fluent; 
            fluent.withResources(instance.getResources()); 
            fluent.withResults(instance.getResults()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public OutputsBuilder(Outputs instance,Validator validator){
            this.fluent = this; 
            this.withResources(instance.getResources()); 
            this.withResults(instance.getResults()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Outputs build(){
            Outputs buildable = new Outputs(fluent.getResources(),fluent.getResults());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OutputsBuilder that = (OutputsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
