package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface OutputsFluent<A extends OutputsFluent<A>> extends Fluent<A>{


    public A addToResources(int index,TaskResource item);
    public A setToResources(int index,TaskResource item);
    public A addToResources(TaskResource... items);
    public A addAllToResources(Collection<TaskResource> items);
    public A removeFromResources(TaskResource... items);
    public A removeAllFromResources(Collection<TaskResource> items);
    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public List<TaskResource> getResources();
    public List<TaskResource> buildResources();
    public TaskResource buildResource(int index);
    public TaskResource buildFirstResource();
    public TaskResource buildLastResource();
    public TaskResource buildMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<TaskResourceBuilder> predicate);
    public Boolean hasMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<TaskResourceBuilder> predicate);
    public A withResources(List<TaskResource> resources);
    public A withResources(TaskResource... resources);
    public Boolean hasResources();
    public A addNewResource(String name,String outputImageDir,String targetPath,String type);
    public OutputsFluent.ResourcesNested<A> addNewResource();
    public OutputsFluent.ResourcesNested<A> addNewResourceLike(TaskResource item);
    public OutputsFluent.ResourcesNested<A> setNewResourceLike(int index,TaskResource item);
    public OutputsFluent.ResourcesNested<A> editResource(int index);
    public OutputsFluent.ResourcesNested<A> editFirstResource();
    public OutputsFluent.ResourcesNested<A> editLastResource();
    public OutputsFluent.ResourcesNested<A> editMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<TaskResourceBuilder> predicate);
    public A addToResults(int index,TestResult item);
    public A setToResults(int index,TestResult item);
    public A addToResults(TestResult... items);
    public A addAllToResults(Collection<TestResult> items);
    public A removeFromResults(TestResult... items);
    public A removeAllFromResults(Collection<TestResult> items);
    
/**
 * This method has been deprecated, please use method buildResults instead.
 * @return The buildable object.
 */
@Deprecated public List<TestResult> getResults();
    public List<TestResult> buildResults();
    public TestResult buildResult(int index);
    public TestResult buildFirstResult();
    public TestResult buildLastResult();
    public TestResult buildMatchingResult(io.fabric8.kubernetes.api.builder.Predicate<TestResultBuilder> predicate);
    public Boolean hasMatchingResult(io.fabric8.kubernetes.api.builder.Predicate<TestResultBuilder> predicate);
    public A withResults(List<TestResult> results);
    public A withResults(TestResult... results);
    public Boolean hasResults();
    public A addNewResult(String format,String name,String path);
    public OutputsFluent.ResultsNested<A> addNewResult();
    public OutputsFluent.ResultsNested<A> addNewResultLike(TestResult item);
    public OutputsFluent.ResultsNested<A> setNewResultLike(int index,TestResult item);
    public OutputsFluent.ResultsNested<A> editResult(int index);
    public OutputsFluent.ResultsNested<A> editFirstResult();
    public OutputsFluent.ResultsNested<A> editLastResult();
    public OutputsFluent.ResultsNested<A> editMatchingResult(io.fabric8.kubernetes.api.builder.Predicate<TestResultBuilder> predicate);

    public interface ResourcesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TaskResourceFluent<OutputsFluent.ResourcesNested<N>>{

        
    public N and();    public N endResource();
}
    public interface ResultsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TestResultFluent<OutputsFluent.ResultsNested<N>>{

        
    public N and();    public N endResult();
}


}
