package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;

public interface PipelineFluent<A extends PipelineFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public PipelineFluent.MetadataNested<A> withNewMetadata();
    public PipelineFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public PipelineFluent.MetadataNested<A> editMetadata();
    public PipelineFluent.MetadataNested<A> editOrNewMetadata();
    public PipelineFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public PipelineSpec getSpec();
    public PipelineSpec buildSpec();
    public A withSpec(PipelineSpec spec);
    public Boolean hasSpec();
    public PipelineFluent.SpecNested<A> withNewSpec();
    public PipelineFluent.SpecNested<A> withNewSpecLike(PipelineSpec item);
    public PipelineFluent.SpecNested<A> editSpec();
    public PipelineFluent.SpecNested<A> editOrNewSpec();
    public PipelineFluent.SpecNested<A> editOrNewSpecLike(PipelineSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public PipelineStatus getStatus();
    public PipelineStatus buildStatus();
    public A withStatus(PipelineStatus status);
    public Boolean hasStatus();
    public PipelineFluent.StatusNested<A> withNewStatus();
    public PipelineFluent.StatusNested<A> withNewStatusLike(PipelineStatus item);
    public PipelineFluent.StatusNested<A> editStatus();
    public PipelineFluent.StatusNested<A> editOrNewStatus();
    public PipelineFluent.StatusNested<A> editOrNewStatusLike(PipelineStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<PipelineFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PipelineSpecFluent<PipelineFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PipelineStatusFluent<PipelineFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
