package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class PipelineListBuilder extends PipelineListFluentImpl<PipelineListBuilder> implements VisitableBuilder<PipelineList,PipelineListBuilder>{

    PipelineListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PipelineListBuilder(){
            this(true);
    }
    public PipelineListBuilder(Boolean validationEnabled){
            this(new PipelineList(), validationEnabled);
    }
    public PipelineListBuilder(PipelineListFluent<?> fluent){
            this(fluent, true);
    }
    public PipelineListBuilder(PipelineListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PipelineList(), validationEnabled);
    }
    public PipelineListBuilder(PipelineListFluent<?> fluent,PipelineList instance){
            this(fluent, instance, true);
    }
    public PipelineListBuilder(PipelineListFluent<?> fluent,PipelineList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineListBuilder(PipelineList instance){
            this(instance,true);
    }
    public PipelineListBuilder(PipelineList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineListBuilder(Validator validator){
            this(new PipelineList(), true);
    }
    public PipelineListBuilder(PipelineListFluent<?> fluent,PipelineList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public PipelineListBuilder(PipelineList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public PipelineList build(){
            PipelineList buildable = new PipelineList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PipelineListBuilder that = (PipelineListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
