package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface PipelineListFluent<A extends PipelineListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Pipeline item);
    public A setToItems(int index,Pipeline item);
    public A addToItems(Pipeline... items);
    public A addAllToItems(Collection<Pipeline> items);
    public A removeFromItems(Pipeline... items);
    public A removeAllFromItems(Collection<Pipeline> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Pipeline> getItems();
    public List<Pipeline> buildItems();
    public Pipeline buildItem(int index);
    public Pipeline buildFirstItem();
    public Pipeline buildLastItem();
    public Pipeline buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<PipelineBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<PipelineBuilder> predicate);
    public A withItems(List<Pipeline> items);
    public A withItems(Pipeline... items);
    public Boolean hasItems();
    public PipelineListFluent.ItemsNested<A> addNewItem();
    public PipelineListFluent.ItemsNested<A> addNewItemLike(Pipeline item);
    public PipelineListFluent.ItemsNested<A> setNewItemLike(int index,Pipeline item);
    public PipelineListFluent.ItemsNested<A> editItem(int index);
    public PipelineListFluent.ItemsNested<A> editFirstItem();
    public PipelineListFluent.ItemsNested<A> editLastItem();
    public PipelineListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<PipelineBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PipelineFluent<PipelineListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
