package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;

public interface PipelineResourceFluent<A extends PipelineResourceFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public PipelineResourceFluent.MetadataNested<A> withNewMetadata();
    public PipelineResourceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public PipelineResourceFluent.MetadataNested<A> editMetadata();
    public PipelineResourceFluent.MetadataNested<A> editOrNewMetadata();
    public PipelineResourceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public PipelineResourceSpec getSpec();
    public PipelineResourceSpec buildSpec();
    public A withSpec(PipelineResourceSpec spec);
    public Boolean hasSpec();
    public PipelineResourceFluent.SpecNested<A> withNewSpec();
    public PipelineResourceFluent.SpecNested<A> withNewSpecLike(PipelineResourceSpec item);
    public PipelineResourceFluent.SpecNested<A> editSpec();
    public PipelineResourceFluent.SpecNested<A> editOrNewSpec();
    public PipelineResourceFluent.SpecNested<A> editOrNewSpecLike(PipelineResourceSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public PipelineResourceStatus getStatus();
    public PipelineResourceStatus buildStatus();
    public A withStatus(PipelineResourceStatus status);
    public Boolean hasStatus();
    public PipelineResourceFluent.StatusNested<A> withNewStatus();
    public PipelineResourceFluent.StatusNested<A> withNewStatusLike(PipelineResourceStatus item);
    public PipelineResourceFluent.StatusNested<A> editStatus();
    public PipelineResourceFluent.StatusNested<A> editOrNewStatus();
    public PipelineResourceFluent.StatusNested<A> editOrNewStatusLike(PipelineResourceStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<PipelineResourceFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PipelineResourceSpecFluent<PipelineResourceFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PipelineResourceStatusFluent<PipelineResourceFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
