package io.fabric8.tekton.pipeline.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface PipelineResourceListFluent<A extends PipelineResourceListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,PipelineResource item);
    public A setToItems(int index,PipelineResource item);
    public A addToItems(PipelineResource... items);
    public A addAllToItems(Collection<PipelineResource> items);
    public A removeFromItems(PipelineResource... items);
    public A removeAllFromItems(Collection<PipelineResource> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<PipelineResource> getItems();
    public List<PipelineResource> buildItems();
    public PipelineResource buildItem(int index);
    public PipelineResource buildFirstItem();
    public PipelineResource buildLastItem();
    public PipelineResource buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<PipelineResourceBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<PipelineResourceBuilder> predicate);
    public A withItems(List<PipelineResource> items);
    public A withItems(PipelineResource... items);
    public Boolean hasItems();
    public PipelineResourceListFluent.ItemsNested<A> addNewItem();
    public PipelineResourceListFluent.ItemsNested<A> addNewItemLike(PipelineResource item);
    public PipelineResourceListFluent.ItemsNested<A> setNewItemLike(int index,PipelineResource item);
    public PipelineResourceListFluent.ItemsNested<A> editItem(int index);
    public PipelineResourceListFluent.ItemsNested<A> editFirstItem();
    public PipelineResourceListFluent.ItemsNested<A> editLastItem();
    public PipelineResourceListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<PipelineResourceBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PipelineResourceFluent<PipelineResourceListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
