package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class PipelineResourceSpecBuilder extends PipelineResourceSpecFluentImpl<PipelineResourceSpecBuilder> implements VisitableBuilder<PipelineResourceSpec,PipelineResourceSpecBuilder>{

    PipelineResourceSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PipelineResourceSpecBuilder(){
            this(true);
    }
    public PipelineResourceSpecBuilder(Boolean validationEnabled){
            this(new PipelineResourceSpec(), validationEnabled);
    }
    public PipelineResourceSpecBuilder(PipelineResourceSpecFluent<?> fluent){
            this(fluent, true);
    }
    public PipelineResourceSpecBuilder(PipelineResourceSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PipelineResourceSpec(), validationEnabled);
    }
    public PipelineResourceSpecBuilder(PipelineResourceSpecFluent<?> fluent,PipelineResourceSpec instance){
            this(fluent, instance, true);
    }
    public PipelineResourceSpecBuilder(PipelineResourceSpecFluent<?> fluent,PipelineResourceSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withParams(instance.getParams()); 
            fluent.withSecrets(instance.getSecrets()); 
            fluent.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineResourceSpecBuilder(PipelineResourceSpec instance){
            this(instance,true);
    }
    public PipelineResourceSpecBuilder(PipelineResourceSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withParams(instance.getParams()); 
            this.withSecrets(instance.getSecrets()); 
            this.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }
    public PipelineResourceSpecBuilder(Validator validator){
            this(new PipelineResourceSpec(), true);
    }
    public PipelineResourceSpecBuilder(PipelineResourceSpecFluent<?> fluent,PipelineResourceSpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withParams(instance.getParams()); 
            fluent.withSecrets(instance.getSecrets()); 
            fluent.withType(instance.getType()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public PipelineResourceSpecBuilder(PipelineResourceSpec instance,Validator validator){
            this.fluent = this; 
            this.withParams(instance.getParams()); 
            this.withSecrets(instance.getSecrets()); 
            this.withType(instance.getType()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public PipelineResourceSpec build(){
            PipelineResourceSpec buildable = new PipelineResourceSpec(fluent.getParams(),fluent.getSecrets(),fluent.getType());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PipelineResourceSpecBuilder that = (PipelineResourceSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
